/*
 * Decompiled with CFR 0.152.
 */
package codecrafter47.bungeetablistplus.data;

import codecrafter47.bungeetablistplus.data.DataAccess;
import codecrafter47.bungeetablistplus.data.DataKey;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class AbstractDataAccess<B>
implements DataAccess<B> {
    protected final Map<DataKey<?>, Function<B, ?>> providersByDataKey = new HashMap();
    private final Map<Class, BiFunction<B, DataKey<?>, ?>> providersByDataKeyClass = new HashMap();

    protected <V> void bind(DataKey<V> dataKey, Function<B, V> provider) {
        this.providersByDataKey.put(dataKey, provider);
    }

    protected <V, K extends DataKey<V>> void bind(Class<K> clazz, BiFunction<B, K, V> provider) {
        this.providersByDataKeyClass.put(clazz, provider);
    }

    @Override
    public <V> V getRawValue(DataKey<V> key, B context) {
        if (this.providersByDataKeyClass.containsKey(key.getClass())) {
            return (V)this.providersByDataKeyClass.get(key.getClass()).apply(context, key);
        }
        if (this.providersByDataKey.containsKey(key)) {
            return (V)this.providersByDataKey.get(key).apply(context);
        }
        return null;
    }

    public boolean provides(DataKey<?> key) {
        return this.providersByDataKey.containsKey(key) || this.providersByDataKeyClass.containsKey(key.getClass());
    }
}

