/*
 * Decompiled with CFR 0.152.
 */
package codecrafter47.bungeetablistplus.bukkitbridge;

import codecrafter47.bungeetablistplus.api.bukkit.BungeeTabListPlusBukkitAPI;
import codecrafter47.bungeetablistplus.api.bukkit.Variable;
import codecrafter47.bungeetablistplus.bukkitbridge.placeholderapi.PlaceholderAPIHook;
import codecrafter47.bungeetablistplus.common.BTLPDataKeys;
import codecrafter47.bungeetablistplus.data.DataAccess;
import codecrafter47.bungeetablistplus.data.DataKey;
import codecrafter47.bungeetablistplus.data.JoinedDataAccess;
import codecrafter47.bungeetablistplus.data.bukkit.AbstractBukkitDataAccess;
import codecrafter47.bungeetablistplus.data.bukkit.PlayerDataAccess;
import codecrafter47.bungeetablistplus.data.bukkit.ServerDataAccess;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BukkitBridge
extends BungeeTabListPlusBukkitAPI
implements Listener {
    private final Plugin plugin;
    private ServerDataUpdateTask serverDataUpdateTask = null;
    private final Map<UUID, PlayerDataUpdateTask> playerInformationUpdaters = new ConcurrentHashMap<UUID, PlayerDataUpdateTask>();
    private DataAccess<Player> playerDataAccess;
    private DataAccess<Server> serverDataAccess;
    private PlaceholderAPIHook placeholderAPIHook = null;
    private final ReadWriteLock apiLock = new ReentrantReadWriteLock();
    private final Map<String, Variable> variablesByName = new HashMap<String, Variable>();
    private final Multimap<Plugin, Variable> variablesByPlugin = HashMultimap.create();

    public BukkitBridge(Plugin plugin) {
        this.plugin = plugin;
    }

    public void onEnable() {
        try {
            Field field = BungeeTabListPlusBukkitAPI.class.getDeclaredField("instance");
            field.setAccessible(true);
            field.set(null, this);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize API", ex);
        }
        this.plugin.getServer().getMessenger().registerOutgoingPluginChannel(this.plugin, "BTLP");
        this.plugin.getServer().getMessenger().registerIncomingPluginChannel(this.plugin, "BTLP", (string, player, bytes) -> {
            try {
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
                String subchannel = in.readUTF();
                if (subchannel.equals("reqP")) {
                    DataKey dataKey = (DataKey)in.readObject();
                    this.getPlayerDataUpdateTask(player).requestValue(dataKey);
                } else if (subchannel.equals("reqS")) {
                    DataKey dataKey = (DataKey)in.readObject();
                    this.serverDataUpdateTask.requestValue(dataKey);
                } else if (subchannel.equals("rstP")) {
                    this.getPlayerDataUpdateTask(player).reset();
                } else if (subchannel.equals("rstS")) {
                    this.serverDataUpdateTask.reset();
                } else if (subchannel.equals("placeholder")) {
                    String placeholder = in.readUTF();
                    PlaceholderAPIHook hook = this.placeholderAPIHook;
                    if (hook != null) {
                        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, () -> {
                            try {
                                if (hook.isPlaceholder(player, placeholder)) {
                                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                                    ObjectOutputStream out = new ObjectOutputStream(os);
                                    out.writeUTF(subchannel);
                                    out.writeUTF(placeholder);
                                    out.close();
                                    player.sendPluginMessage(this.plugin, "BTLP", os.toByteArray());
                                }
                            }
                            catch (Throwable ex) {
                                this.plugin.getLogger().log(Level.WARNING, "PlaceholderAPI error", ex);
                            }
                        });
                    }
                } else {
                    this.plugin.getLogger().warning("Received plugin message of unknown format. Proxy/Bukkit plugin version mismatch?");
                }
            }
            catch (IOException | ClassNotFoundException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "An error occurred while handling an incoming plugin message", ex);
            }
        });
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        this.updateDataHooks();
        this.serverDataUpdateTask = new ServerDataUpdateTask();
        this.serverDataUpdateTask.runTaskTimerAsynchronously(this.plugin, 0L, 20L);
        this.plugin.getServer().getOnlinePlayers().forEach(this::getPlayerDataUpdateTask);
    }

    private void updateDataHooks() {
        this.placeholderAPIHook = this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null ? new PlaceholderAPIHook(this.plugin) : null;
        this.playerDataAccess = this.placeholderAPIHook != null ? JoinedDataAccess.of(new PlayerDataAccess(this.plugin), new ThirdPartyVariablesAccess(), this.placeholderAPIHook.getDataAccess()) : JoinedDataAccess.of(new PlayerDataAccess(this.plugin), new ThirdPartyVariablesAccess());
        this.serverDataAccess = JoinedDataAccess.of(new ServerDataAccess(this.plugin), new BTLPServerDataKeyAccess());
    }

    private PlayerDataUpdateTask getPlayerDataUpdateTask(Player player) {
        if (this.playerInformationUpdaters.get(player.getUniqueId()) == null) {
            PlayerDataUpdateTask playerDataUpdateTask = new PlayerDataUpdateTask(player);
            playerDataUpdateTask.runTaskTimerAsynchronously(this.plugin, 0L, 20L);
            this.playerInformationUpdaters.put(player.getUniqueId(), playerDataUpdateTask);
        }
        return this.playerInformationUpdaters.get(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.getPlayerDataUpdateTask(event.getPlayer());
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.playerInformationUpdaters.containsKey(player.getUniqueId())) {
            try {
                this.playerInformationUpdaters.remove(player.getUniqueId()).cancel();
            }
            catch (Exception ex) {
                this.plugin.getLogger().log(Level.SEVERE, "An exception occurred while removing a player", ex);
            }
        }
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        this.updateDataHooks();
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        this.updateDataHooks();
    }

    protected void sendInformation(String subchannel, Map<DataKey<?>, Object> delta, Player player) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(os);
            out.writeUTF(subchannel);
            out.writeObject(delta);
            out.close();
            player.sendPluginMessage(this.plugin, "BTLP", os.toByteArray());
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, null, ex);
        }
    }

    protected void sendHash(String subchannel, int hash, Player player) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(os);
            out.writeUTF(subchannel);
            out.writeInt(hash);
            out.close();
            player.sendPluginMessage(this.plugin, "BTLP", os.toByteArray());
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void registerVariable0(Plugin plugin, Variable variable) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        Preconditions.checkNotNull((Object)variable, (Object)"variable");
        this.apiLock.writeLock().lock();
        try {
            Preconditions.checkArgument((!this.variablesByName.containsKey(variable.getName()) ? 1 : 0) != 0, (Object)"variable already registered");
            this.variablesByName.put(variable.getName(), variable);
            this.variablesByPlugin.put((Object)plugin, (Object)variable);
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    @Override
    protected void unregisterVariable0(Variable variable) {
        Preconditions.checkNotNull((Object)variable, (Object)"variable");
        this.apiLock.writeLock().lock();
        try {
            Preconditions.checkArgument((boolean)this.variablesByName.remove(variable.getName(), variable), (Object)"variable not registered");
            this.variablesByPlugin.values().remove(variable);
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unregisterVariables0(Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        this.apiLock.writeLock().lock();
        try {
            for (Variable variable : this.variablesByPlugin.removeAll((Object)plugin)) {
                this.variablesByName.remove(variable.getName());
            }
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    public class PlayerDataUpdateTask
    extends DataUpdateTask<Player> {
        private final Player player;

        public PlayerDataUpdateTask(Player player) {
            this.player = player;
        }

        public void run() {
            this.update(this.player, BukkitBridge.this.playerDataAccess, this.player, "updateP");
            BukkitBridge.this.sendHash("hashP", this.sentData.hashCode(), this.player);
        }
    }

    public class ServerDataUpdateTask
    extends DataUpdateTask<Server> {
        public void run() {
            BukkitBridge.this.plugin.getServer().getOnlinePlayers().stream().findAny().ifPresent(player -> {
                this.update((Player)player, BukkitBridge.this.serverDataAccess, BukkitBridge.this.plugin.getServer(), "updateS");
                BukkitBridge.this.sendHash("hashS", this.sentData.hashCode(), (Player)player);
            });
        }
    }

    public abstract class DataUpdateTask<B>
    extends BukkitRunnable {
        Map<DataKey<?>, Object> sentData = new ConcurrentHashMap();
        ImmutableSet<DataKey<?>> requestedData = ImmutableSet.of();
        boolean requestedReset = true;

        protected final void update(Player player, DataAccess<B> dataAccess, B boundType, String subchannel) {
            ConcurrentHashMap newData = new ConcurrentHashMap();
            this.requestedData.parallelStream().forEach(value -> dataAccess.getValue(value, boundType).ifPresent(data -> newData.put((DataKey<?>)value, data)));
            HashMap delta = new HashMap();
            for (Map.Entry<DataKey<?>, Object> entry : this.sentData.entrySet()) {
                if (!newData.containsKey(entry.getKey())) {
                    delta.put(entry.getKey(), null);
                    continue;
                }
                if (Objects.equals(newData.get(entry.getKey()), entry.getValue())) continue;
                delta.put(entry.getKey(), newData.get(entry.getKey()));
            }
            for (Map.Entry<DataKey<Object>, Object> entry : newData.entrySet()) {
                if (!this.requestedReset && this.sentData.containsKey(entry.getKey())) continue;
                delta.put(entry.getKey(), entry.getValue());
            }
            if (!delta.isEmpty()) {
                BukkitBridge.this.sendInformation(subchannel, delta, player);
            }
            this.sentData = newData;
            if (this.requestedReset) {
                this.requestedReset = false;
            }
        }

        public void requestValue(DataKey<?> dataKey) {
            if (!this.requestedData.contains(dataKey)) {
                this.requestedData = ImmutableSet.builder().addAll(this.requestedData).add(dataKey).build();
            }
        }

        public void reset() {
            this.requestedReset = true;
        }
    }

    private class BTLPServerDataKeyAccess
    extends AbstractBukkitDataAccess<Server> {
        public BTLPServerDataKeyAccess() {
            super(BukkitBridge.this.plugin.getLogger(), BukkitBridge.this.plugin);
            this.bind(BTLPDataKeys.REGISTERED_THIRD_PARTY_VARIABLES, (B server) -> {
                BukkitBridge.this.apiLock.readLock().lock();
                try {
                    ArrayList arrayList = Lists.newArrayList(BukkitBridge.this.variablesByName.keySet());
                    return arrayList;
                }
                finally {
                    BukkitBridge.this.apiLock.readLock().unlock();
                }
            });
            this.bind(BTLPDataKeys.PLACEHOLDERAPI_PRESENT, (B server) -> BukkitBridge.this.placeholderAPIHook != null);
        }
    }

    private class ThirdPartyVariablesAccess
    extends AbstractBukkitDataAccess<Player> {
        public ThirdPartyVariablesAccess() {
            super(BukkitBridge.this.plugin.getLogger(), BukkitBridge.this.plugin);
            this.bind(BTLPDataKeys.ThirdPartyVariableDataKey.class, this::resolveVariable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String resolveVariable(Player player, BTLPDataKeys.ThirdPartyVariableDataKey key) {
            BukkitBridge.this.apiLock.readLock().lock();
            try {
                Variable variable = (Variable)BukkitBridge.this.variablesByName.get(key.getName());
                if (variable != null) {
                    String replacement = null;
                    try {
                        replacement = variable.getReplacement(player);
                    }
                    catch (Throwable th) {
                        BukkitBridge.this.plugin.getLogger().log(Level.WARNING, "An exception occurred while resolving a variable provided by a third party plugin", th);
                    }
                    String string = replacement;
                    return string;
                }
                String string = null;
                return string;
            }
            finally {
                BukkitBridge.this.apiLock.readLock().unlock();
            }
        }
    }
}

