/*
 * Decompiled with CFR 0.152.
 */
package de.JeterLP.ChatManager.update;

import de.JeterLP.ChatManager.update.Config;
import de.JeterLP.ChatManager.update.ReleaseType;
import de.JeterLP.ChatManager.update.UpdateType;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Updater {
    private final int id;
    private URL url;
    private final JavaPlugin main;
    private final String link;
    private final String repo_owner;
    private final String repo_name;
    private final boolean enabled;
    private final UpdateType type;
    private final ReleaseType rType;
    private final Config config;
    private final boolean useGithub;
    private static Updater INSTANCE;

    public Updater(JavaPlugin main, int id, String link, String repo_owner, String repo_name) {
        main.getLogger().info("Loading updater by TheJeterLP. Project id: " + id);
        this.config = new Config(main, "update-config.yml");
        this.type = Config.Values.UPDATE_TYPE.getUpdateType(this.config);
        this.rType = Config.Values.RELEASE_TYPE.getReleaseType(this.config);
        this.main = main;
        this.id = id;
        this.link = "http://dev.bukkit.org/bukkit-plugins/" + link;
        this.useGithub = true;
        this.repo_name = repo_name;
        this.repo_owner = repo_owner;
        boolean enable = id == -1 ? false : Config.Values.ENABLED.getBoolean(this.config);
        try {
            this.url = this.useGithub && this.rType == ReleaseType.GITHUB ? new URL("https://api.github.com/repos/" + repo_owner + "/" + repo_name + "/releases/latest") : new URL("https://api.curseforge.com/servermods/files?projectIds=" + this.id);
        }
        catch (MalformedURLException ex) {
            enable = false;
            ex.printStackTrace();
        }
        this.enabled = enable;
        main.getLogger().info("Updatechecker is " + (this.enabled ? "enabled" : "disabled") + ".");
        INSTANCE = this;
    }

    public Updater(JavaPlugin main, int id, String link) {
        main.getLogger().info("Loading updater by TheJeterLP. Project id: " + id);
        this.config = new Config(main, "update-config.yml");
        this.type = Config.Values.UPDATE_TYPE.getUpdateType(this.config);
        this.rType = Config.Values.RELEASE_TYPE.getReleaseType(this.config);
        this.main = main;
        this.id = id;
        this.link = "http://dev.bukkit.org/bukkit-plugins/" + link;
        this.useGithub = false;
        this.repo_name = "";
        this.repo_owner = "";
        boolean enable = id == -1 ? false : Config.Values.ENABLED.getBoolean(this.config);
        try {
            this.url = new URL("https://api.curseforge.com/servermods/files?projectIds=" + this.id);
        }
        catch (MalformedURLException ex) {
            enable = false;
            ex.printStackTrace();
        }
        this.enabled = enable;
        main.getLogger().info("Updatechecker is " + (this.enabled ? "enabled" : "disabled") + ".");
        INSTANCE = this;
    }

    public void search() {
        this.debug("Method: search()");
        if (!this.enabled) {
            return;
        }
        this.main.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.main, new Runnable(){

            @Override
            public void run() {
                String[] data = Updater.this.read();
                if (Updater.this.checkForNewVersions(data)) {
                    Updater.this.main.getLogger().info("A new update is available! (" + data[1] + ") current: " + Updater.this.main.getDescription().getVersion());
                    if (Updater.this.type == UpdateType.ANNOUNCE) {
                        if (Updater.this.isUsingGithub()) {
                            Updater.this.main.getLogger().info("You can get it at: https://github.com/" + Updater.this.repo_owner + "/" + Updater.this.repo_name + "/releases");
                        } else {
                            Updater.this.main.getLogger().info("You can get it at: " + Updater.this.link);
                        }
                    } else {
                        Updater.this.main.getLogger().info("It will be downloaded for you and will be installed automatically when the server restarts.");
                    }
                }
            }
        }, 60L);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public JavaPlugin getPlugin() {
        return this.main;
    }

    public UpdateType getUpdateType() {
        return this.type;
    }

    public ReleaseType getReleaseType() {
        return this.rType;
    }

    public String getLink() {
        return this.link;
    }

    protected boolean checkForNewVersions(String[] data) {
        this.debug("Method: checkForNewVersions(String[])");
        if (data == null || !this.versionCheck(data)) {
            return false;
        }
        if (this.type == UpdateType.DOWNLOAD) {
            this.downloadFile(data);
        }
        return true;
    }

    protected boolean versionCheck(String[] data) {
        int i;
        int missing;
        ReleaseType releaseType;
        this.debug("Method: versionCheck(String[])");
        String title = data[1];
        if (this.rType != ReleaseType.ALL && (releaseType = ReleaseType.valueOf(data[2].toUpperCase())) != this.rType) {
            this.debug("Releasetype of the new file does not match the one which we search for! Ignoring the file...");
            return false;
        }
        String remote = title.contains("v") ? title.split("v")[1] : title;
        if (remote.contains("-")) {
            remote = remote.split("-")[0];
        }
        ArrayList<String> rNumbers = new ArrayList<String>();
        ArrayList<String> numbers = new ArrayList<String>();
        rNumbers.addAll(Arrays.asList(remote.split("\\.")));
        if (this.main.getDescription().getVersion().contains("-")) {
            numbers.addAll(Arrays.asList(this.main.getDescription().getVersion().split("-")[0].split("\\.")));
            this.debug("numbers: " + Arrays.toString(numbers.toArray()));
        } else {
            numbers.addAll(Arrays.asList(this.main.getDescription().getVersion().split("\\.")));
            this.debug("numbers: " + Arrays.toString(numbers.toArray()));
        }
        if (rNumbers.size() > numbers.size()) {
            missing = rNumbers.size() - numbers.size();
            for (i = 0; i < missing; ++i) {
                numbers.add("0");
            }
        } else if (numbers.size() > rNumbers.size()) {
            missing = numbers.size() - rNumbers.size();
            for (i = 0; i < missing; ++i) {
                rNumbers.add("0");
            }
        }
        this.debug("numbers: " + Arrays.toString(numbers.toArray()));
        this.debug("rNumbers: " + Arrays.toString(rNumbers.toArray()));
        for (int i2 = 0; i2 < rNumbers.size(); ++i2) {
            int number;
            int rNumber = Integer.valueOf((String)rNumbers.get(i2));
            if (rNumber > (number = Integer.valueOf((String)numbers.get(i2)).intValue())) {
                this.debug(rNumber + " is bigger than " + number + ". This means there is a new version. Returnign true...");
                return true;
            }
            if (number <= rNumber) continue;
            this.main.getLogger().info("It seems that your version is newer than the one on BukkitDev. Maybe you are using a development build?");
            return false;
        }
        this.main.getLogger().info("There is no new version available. You are up-to-date!");
        return false;
    }

    protected String[] read() {
        this.debug("Method: read()");
        try {
            String downloadUrl;
            String name;
            String releaseType;
            URLConnection conn = this.url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setDoOutput(true);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String response = reader.readLine();
            if (this.isUsingGithub()) {
                releaseType = "Github";
                JSONObject o = (JSONObject)JSONValue.parse((String)response);
                name = o.get((Object)"name").toString();
                JSONArray a = (JSONArray)o.get((Object)"assets");
                JSONObject ob = (JSONObject)a.get(0);
                downloadUrl = (String)ob.get((Object)"browser_download_url");
                this.debug(downloadUrl);
                this.debug(name);
            } else {
                JSONArray array = (JSONArray)JSONValue.parse((String)response);
                if (array.isEmpty()) {
                    return null;
                }
                Map map = (Map)array.get(array.size() - 1);
                int index = 1;
                releaseType = (String)map.get("releaseType");
                if (this.rType != ReleaseType.ALL) {
                    ReleaseType release = ReleaseType.valueOf(releaseType.toUpperCase());
                    while (release != this.rType) {
                        this.debug("Releasetype of the new file does not match the one which we search for! Ignoring the file...");
                        this.debug("Getting next file...");
                        if (array.size() - ++index < 0) {
                            return null;
                        }
                        map = (Map)array.get(array.size() - index);
                        if (map == null) {
                            return null;
                        }
                        releaseType = (String)map.get("releaseType");
                        release = ReleaseType.valueOf(releaseType.toUpperCase());
                    }
                }
                downloadUrl = (String)map.get("downloadUrl");
                name = (String)map.get("name");
            }
            return new String[]{downloadUrl, name, releaseType};
        }
        catch (Exception e) {
            this.main.getLogger().severe("Error on trying to check remote versions. Error: " + e);
            e.printStackTrace();
            return null;
        }
    }

    public void downloadFile(final String url) {
        this.main.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.main, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedInputStream in = null;
                FileOutputStream fout = null;
                try {
                    int count;
                    File update = Updater.this.main.getServer().getUpdateFolderFile();
                    if (!update.exists()) {
                        update.mkdirs();
                    }
                    URL url2 = new URL(url);
                    int fileLength = url2.openConnection().getContentLength();
                    String fileName = new File(Updater.this.main.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getName();
                    File target = new File(update, fileName);
                    Updater.this.debug("Downloading File: " + url2.toString());
                    in = new BufferedInputStream(url2.openStream());
                    fout = new FileOutputStream(target);
                    byte[] data = new byte[1024];
                    long downloaded = 0L;
                    while ((count = in.read(data, 0, 1024)) != -1) {
                        fout.write(data, 0, count);
                        int percent = (int)((downloaded += (long)count) * 100L / (long)fileLength);
                        if (percent % 10 != 0) continue;
                        Updater.this.main.getLogger().info("Downloaded " + percent + "% of " + fileLength + " bytes.");
                    }
                    Updater.this.main.getLogger().info("Download done!");
                }
                catch (Exception ex) {
                    Updater.this.main.getLogger().severe("Error on trying to download update. Error: " + ex);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (fout != null) {
                            fout.close();
                        }
                    }
                    catch (Exception ex) {
                        Updater.this.main.getLogger().severe("Error on trying to close Streams. Error: " + ex);
                    }
                }
            }
        });
    }

    protected void downloadFile(String[] dat) {
        this.debug("Method: downloadFile(String[])");
        if (this.isUsingGithub()) {
            this.main.getLogger().info("Downloading github Development build from https://github.com/" + this.repo_owner + "/" + this.repo_name + "/releases/");
        } else {
            this.main.getLogger().info("Downloading update from " + this.link);
        }
        String dl = "";
        if (!this.isUsingGithub()) {
            try {
                URL u = new URL(dat[0]);
                dl = "https://addons-origin.cursecdn.com" + u.getFile();
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        } else {
            dl = dat[0];
        }
        this.downloadFile(dl);
    }

    protected void debug(String message) {
        if (!Config.Values.DEBUG.getBoolean(this.config)) {
            return;
        }
        this.main.getLogger().info("[Debug] " + message);
    }

    public String getRepoOwner() {
        return this.repo_owner;
    }

    public String getRepoName() {
        return this.repo_name;
    }

    public boolean isUsingGithub() {
        return this.useGithub && this.rType == ReleaseType.GITHUB;
    }

    public static Updater getInstance() {
        return INSTANCE;
    }
}

