/*
 * Decompiled with CFR 0.152.
 */
package de.JeterLP.ChatManager.update;

import de.JeterLP.ChatManager.update.ReleaseType;
import de.JeterLP.ChatManager.update.UpdateType;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Config {
    private final YamlConfiguration cfg;
    private final File f;

    public Config(JavaPlugin pl, String cfgFile) {
        pl.getLogger().info("Loading updater-config...");
        pl.getDataFolder().mkdirs();
        this.f = new File(pl.getDataFolder(), cfgFile);
        this.cfg = YamlConfiguration.loadConfiguration((File)this.f);
        String header = "Updater config for the plugin " + pl.getName() + ". (Automaticaly generated)\n";
        for (Values c : Values.values()) {
            header = header + c.getPath() + ": " + c.getComment() + "\n";
            if (this.cfg.contains(c.getPath())) continue;
            this.cfg.set(c.getPath(), c.getDefaultValue());
        }
        this.cfg.options().header(header);
        try {
            this.cfg.save(this.f);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        pl.getLogger().info("Done!");
    }

    public YamlConfiguration getConfig() {
        return this.cfg;
    }

    public File getFile() {
        return this.f;
    }

    public static enum Values {
        ENABLED("Enabled", true, "Is the updater enabled?"),
        UPDATE_TYPE("Update-Type", UpdateType.DOWNLOAD.toString(), "DOWNLOAD: Download the new version. ANNOUNCE: Only say that a new version was released."),
        RELEASE_TYPE("Release-Type", ReleaseType.RELEASE.toString(), "ALPHA: Only download alpha files. BETA: Only download files. RELEASE: Only download release files. ALL: Download all files."),
        DEBUG("Debug", false, "Toggles the debug logging");

        private final Object value;
        private final String path;
        private final String comment;

        private Values(String path, Object val, String comment) {
            this.path = path;
            this.value = val;
            this.comment = comment;
        }

        public Object getDefaultValue() {
            return this.value;
        }

        public String getPath() {
            return this.path;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean getBoolean(Config c) {
            return c.getConfig().getBoolean(this.path);
        }

        public UpdateType getUpdateType(Config c) {
            return UpdateType.valueOf(c.getConfig().getString(this.path, UpdateType.DOWNLOAD.toString()).toUpperCase());
        }

        public ReleaseType getReleaseType(Config c) {
            return ReleaseType.valueOf(c.getConfig().getString(this.path, ReleaseType.ALL.toString()).toUpperCase());
        }
    }
}

