/*
 * Decompiled with CFR 0.152.
 */
package de.JeterLP.ChatManager.Utils;

import com.massivecraft.factions.entity.Faction;
import com.massivecraft.factions.entity.MPlayer;
import de.JeterLP.ChatManager.ChatEX;
import de.JeterLP.ChatManager.ChatListener;
import de.JeterLP.ChatManager.Plugins.PluginManager;
import de.JeterLP.ChatManager.Utils.ChatLogger;
import de.JeterLP.ChatManager.Utils.Config;
import de.JeterLP.ChatManager.Utils.HookManager;
import de.JeterLP.ChatManager.Utils.Locales;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Utils {
    private static final Pattern chatColorPattern = Pattern.compile("(?i)&([0-9A-F])");
    private static final Pattern chatMagicPattern = Pattern.compile("(?i)&([K])");
    private static final Pattern chatBoldPattern = Pattern.compile("(?i)&([L])");
    private static final Pattern chatStrikethroughPattern = Pattern.compile("(?i)&([M])");
    private static final Pattern chatUnderlinePattern = Pattern.compile("(?i)&([N])");
    private static final Pattern chatItalicPattern = Pattern.compile("(?i)&([O])");
    private static final Pattern chatResetPattern = Pattern.compile("(?i)&([R])");
    private static final Pattern ipPattern = Pattern.compile("((?<![0-9])(?:(?:25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2})[ ]?[.,-:; ][ ]?(?:25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2})[ ]?[., ][ ]?(?:25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2})[ ]?[., ][ ]?(?:25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2}))(?![0-9]))");
    private static final Pattern webpattern = Pattern.compile("[-a-zA-Z0-9@:%_\\+.~#?&//=]{2,256}\\.[a-z]{2,4}\\b(\\/[-a-zA-Z0-9@:%_\\+~#?&//=]*)?");
    private static final String permissionChatColor = "chatex.chat.color";
    private static final String permissionChatMagic = "chatex.chat.magic";
    private static final String permissionChatBold = "chatex.chat.bold";
    private static final String permissionChatStrikethrough = "chatex.chat.strikethrough";
    private static final String permissionChatUnderline = "chatex.chat.underline";
    private static final String permissionChatItalic = "chatex.chat.italic";
    private static final String permissionChatReset = "chatex.chat.reset";

    public static String translateColorCodes(String string, Player p) {
        if (string == null) {
            return "";
        }
        String newstring = string;
        if (p.hasPermission(permissionChatColor)) {
            newstring = chatColorPattern.matcher(newstring).replaceAll("\u00a7$1");
        }
        if (p.hasPermission(permissionChatMagic)) {
            newstring = chatMagicPattern.matcher(newstring).replaceAll("\u00a7$1");
        }
        if (p.hasPermission(permissionChatBold)) {
            newstring = chatBoldPattern.matcher(newstring).replaceAll("\u00a7$1");
        }
        if (p.hasPermission(permissionChatStrikethrough)) {
            newstring = chatStrikethroughPattern.matcher(newstring).replaceAll("\u00a7$1");
        }
        if (p.hasPermission(permissionChatUnderline)) {
            newstring = chatUnderlinePattern.matcher(newstring).replaceAll("\u00a7$1");
        }
        if (p.hasPermission(permissionChatItalic)) {
            newstring = chatItalicPattern.matcher(newstring).replaceAll("\u00a7$1");
        }
        if (p.hasPermission(permissionChatReset)) {
            newstring = chatResetPattern.matcher(newstring).replaceAll("\u00a7$1");
        }
        return newstring;
    }

    public static String replaceColors(String message) {
        return message.replaceAll("&((?i)[0-9a-fk-or])", "\u00a7$1");
    }

    public static List<Player> getLocalRecipients(Player sender) {
        Location playerLocation = sender.getLocation();
        ArrayList<Player> recipients = new ArrayList<Player>();
        double squaredDistance = Math.pow(Config.RANGE.getDouble(), 2.0);
        for (Player recipient : sender.getWorld().getPlayers()) {
            if (playerLocation.distanceSquared(recipient.getLocation()) > squaredDistance) continue;
            recipients.add(recipient);
        }
        return recipients;
    }

    public static String replacePlayerPlaceholders(Player player, String format) {
        String result = format;
        result = result.replace("%displayname", player.getDisplayName());
        result = result.replace("%prefix", PluginManager.getInstance().getPrefix(player));
        result = result.replace("%suffix", PluginManager.getInstance().getSuffix(player));
        result = result.replace("%player", player.getDisplayName());
        result = result.replace("%world", player.getWorld().getName());
        result = result.replace("%group", PluginManager.getInstance().getGroupNames(player)[0]);
        result = Utils.replaceTime(result);
        result = Utils.replaceFaction(player, result);
        result = Utils.replaceColors(result);
        return result;
    }

    private static String replaceTime(String message) {
        String month;
        String hour;
        Calendar calendar = Calendar.getInstance();
        if (message.contains("%time")) {
            SimpleDateFormat date = new SimpleDateFormat("HH:mm:ss");
            message = message.replace("%time", date.format(calendar.getTime()));
        }
        if (message.contains("%h")) {
            hour = String.valueOf(calendar.get(10));
            message = message.replace("%h", hour);
        }
        if (message.contains("%H")) {
            hour = String.valueOf(calendar.get(11));
            message = message.replace("%H", hour);
        }
        if (message.contains("%i")) {
            String minute = String.valueOf(calendar.get(12));
            message = message.replace("%i", minute);
        }
        if (message.contains("%s")) {
            String second = String.valueOf(calendar.get(13));
            message = message.replace("%s", second);
        }
        if (message.contains("%a")) {
            message = message.replace("%a", calendar.get(9) == 0 ? "am" : "pm");
        }
        if (message.contains("%A")) {
            message = message.replace("%A", calendar.get(9) == 0 ? "AM" : "PM");
        }
        if (message.contains("%m")) {
            month = String.valueOf(calendar.get(2));
            message = message.replace("%m", month);
        }
        if (message.contains("%M")) {
            month = "";
            int monat = calendar.get(2) + 1;
            switch (monat) {
                case 1: {
                    month = "January";
                    break;
                }
                case 2: {
                    month = "February";
                    break;
                }
                case 3: {
                    month = "March";
                    break;
                }
                case 4: {
                    month = "April";
                    break;
                }
                case 5: {
                    month = "May";
                    break;
                }
                case 6: {
                    month = "June";
                    break;
                }
                case 7: {
                    month = "July";
                    break;
                }
                case 8: {
                    month = "August";
                    break;
                }
                case 9: {
                    month = "September";
                    break;
                }
                case 10: {
                    month = "October";
                    break;
                }
                case 11: {
                    month = "November";
                    break;
                }
                case 12: {
                    month = "December";
                    break;
                }
                default: {
                    month = Locales.COMMAND_CLEAR_UNKNOWN.getString();
                }
            }
            message = message.replace("%M", month);
        }
        if (message.contains("%y")) {
            String year = String.valueOf(calendar.get(1));
            message = message.replace("%m", year);
        }
        if (message.contains("%Y")) {
            int year = calendar.get(1);
            String year_new = String.valueOf(year);
            year_new = year_new.replace("19", "").replace("20", "");
            message = message.replace("%Y", year_new);
        }
        if (message.contains("%d")) {
            String day = String.valueOf(calendar.get(8));
            message = message.replace("%d", day);
        }
        if (message.contains("%D")) {
            String day = String.valueOf(calendar.get(7));
            message = message.replace("%D", day);
        }
        message = Utils.replaceColors(message);
        return message;
    }

    public static boolean registerListener() {
        try {
            String prio = Config.EVENTPRIORITY.getString();
            Object listener = Class.forName("de.JeterLP.ChatManager.Listeners." + prio).newInstance();
            if (listener instanceof ChatListener) {
                ChatListener l = (ChatListener)listener;
                l.register();
                ChatEX.getInstance().getLogger().info("Listener registered with Priority: " + prio);
                return true;
            }
            ChatEX.getInstance().getLogger().severe("Listener is not an instance of the Listener Class.");
            return false;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String replaceFaction(Player player, String msg) {
        if (!HookManager.checkFactions()) {
            return msg.replace("%faction", "");
        }
        MPlayer uplayer = MPlayer.get((Object)player);
        Faction faction = uplayer.getFaction();
        return msg.replace("%faction", faction.getName());
    }

    private static boolean checkForIPPattern(String message) {
        ChatEX.debug("IP: Searching for ip: " + message);
        message = message.replaceAll(" ", "");
        Matcher regexMatcher = ipPattern.matcher(message);
        while (regexMatcher.find()) {
            ChatEX.debug("IP: Found!");
            if (regexMatcher.group().length() == 0) continue;
            String text = regexMatcher.group().trim().replaceAll("http://", "").replaceAll("https://", "").split("/")[0];
            ChatEX.debug("IP: AdCheck ip: " + text);
            ChatEX.debug("IP: AdCheck length: " + text.split("\\.").length);
            if (text.split("\\.").length > 4) {
                ChatEX.debug("IP: Removing subdomains...");
                Object[] domains = text.split("\\.");
                ChatEX.debug("IP: AdCheck 1:" + Arrays.toString(domains));
                Object one = domains[domains.length - 1];
                ChatEX.debug("IP: AdCheck 2:" + (String)one);
                Object two = domains[domains.length - 2];
                ChatEX.debug("IP: AdCheck 3:" + (String)two);
                Object three = domains[domains.length - 3];
                ChatEX.debug("IP: AdCheck 4:" + (String)three);
                Object four = domains[domains.length - 4];
                ChatEX.debug("IP: AdCheck 5:" + (String)four);
                text = (String)one + "." + (String)two + "." + (String)three + "." + (String)four;
                ChatEX.debug("AdCheck 6:" + text);
            }
            if (!ipPattern.matcher(text).find() || Config.ADS_BYPASS.getStringList().contains(regexMatcher.group().trim())) continue;
            ChatEX.debug("IP: Found ad: " + text);
            return true;
        }
        return false;
    }

    private static boolean checkForWebPattern(String message) {
        ChatEX.debug("WEB: Searching for url: " + message);
        message = message.replaceAll(" ", "");
        Matcher regexMatcher = webpattern.matcher(message);
        while (regexMatcher.find()) {
            ChatEX.debug("WEB: Found!");
            if (regexMatcher.group().length() == 0) continue;
            String text = regexMatcher.group().trim().replaceAll("http://", "").replaceAll("https://", "").split("/")[0];
            ChatEX.debug("WEB: AdCheck url: " + text);
            ChatEX.debug("WEB: AdCheck length: " + text.split("\\.").length);
            if (text.split("\\.").length > 2) {
                ChatEX.debug("WEB: Removing subdomains...");
                Object[] domains = text.split("\\.");
                ChatEX.debug("WEB: AdCheck 1:" + Arrays.toString(domains));
                Object toplevel = domains[domains.length - 1];
                ChatEX.debug("WEB: AdCheck 2:" + (String)toplevel);
                Object second = domains[domains.length - 2];
                ChatEX.debug("WEB: AdCheck 3:" + (String)second);
                text = (String)second + "." + (String)toplevel;
                ChatEX.debug("WEB: AdCheck 4:" + text);
            }
            if (!webpattern.matcher(text).find() || Config.ADS_BYPASS.getStringList().contains(text)) continue;
            ChatEX.debug("WEB: Found ad: " + text);
            return true;
        }
        return false;
    }

    public static boolean check(String msg, Player p) {
        boolean found;
        ChatEX.debug("Checking for advertising...");
        if (p.hasPermission("chatex.bypassads")) {
            return false;
        }
        if (!Config.ADS_ENABLED.getBoolean()) {
            return false;
        }
        boolean bl = found = Utils.checkForIPPattern(msg) || Utils.checkForWebPattern(msg);
        if (found) {
            for (Player op : ChatEX.getInstance().getServer().getOnlinePlayers()) {
                if (!op.hasPermission("chatex.notifyad")) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("%player", p.getName());
                map.put("%message", msg);
                Locales.MESSAGES_AD_NOTIFY.send((CommandSender)op, map);
            }
            ChatLogger.writeToAdFile(p, msg);
        }
        return found;
    }
}

