/*
 * Decompiled with CFR 0.152.
 */
package de.JeterLP.ChatManager.Plugins;

import de.JeterLP.ChatManager.Plugins.PermissionsPlugin;
import de.JeterLP.ChatManager.Utils.Config;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Vault
implements PermissionsPlugin {
    private static Chat chat = null;

    @Override
    public String getPrefix(Player p) {
        if (!Config.MULTIPREFIXES.getBoolean()) {
            return chat.getPlayerPrefix(p.getWorld().getName(), (OfflinePlayer)p);
        }
        String finalPrefix = "";
        for (String group : chat.getPlayerGroups(p)) {
            String groupPrefix = chat.getGroupPrefix(p.getWorld(), group);
            if (groupPrefix == null || groupPrefix.isEmpty()) continue;
            finalPrefix = finalPrefix + groupPrefix;
        }
        return finalPrefix;
    }

    @Override
    public String getSuffix(Player p) {
        if (!Config.MULTIPREFIXES.getBoolean()) {
            return chat.getPlayerSuffix(p.getWorld().getName(), (OfflinePlayer)p);
        }
        String finalSuffix = "";
        for (String group : chat.getPlayerGroups(p)) {
            String groupSuffix = chat.getGroupSuffix(p.getWorld(), group);
            if (groupSuffix == null || groupSuffix.isEmpty()) continue;
            finalSuffix = finalSuffix + groupSuffix;
        }
        return finalSuffix;
    }

    @Override
    public String[] getGroupNames(Player p) {
        return chat.getPlayerGroups(p.getWorld().getName(), (OfflinePlayer)p);
    }

    @Override
    public String getName() {
        return chat.getName();
    }

    @Override
    public String getMessageFormat(Player p) {
        return Config.FORMAT.getString();
    }

    @Override
    public String getGlobalMessageFormat(Player p) {
        return Config.GLOBALFORMAT.getString();
    }

    protected static boolean setupChat() {
        try {
            RegisteredServiceProvider chatProvider = Bukkit.getServer().getServicesManager().getRegistration(Chat.class);
            if (chatProvider != null && chatProvider.getProvider() != null) {
                chat = (Chat)chatProvider.getProvider();
                return chat != null && chat.isEnabled();
            }
            return false;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

