/*
 * Decompiled with CFR 0.152.
 */
package de.JeterLP.ChatManager.Command;

import de.JeterLP.ChatManager.Command.CommandArgs;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class HelpPage {
    private final List<CommandHelp> helpPages = new ArrayList<CommandHelp>();
    private final List<String> HELP_TEXT = new ArrayList<String>();
    private final String command;

    public HelpPage(String command) {
        this.command = command;
    }

    public void addPage(String argument, String description) {
        if (argument.isEmpty()) {
            this.helpPages.add(new CommandHelp(this.command, description));
        } else {
            this.helpPages.add(new CommandHelp(this.command + " " + argument, description));
        }
    }

    public void prepare() {
        if (this.helpPages == null || this.helpPages.isEmpty()) {
            return;
        }
        this.HELP_TEXT.add(ChatColor.GREEN + "------------------------" + ChatColor.BLUE + "Help" + ChatColor.GREEN + "-------------------------");
        for (CommandHelp ch : this.helpPages) {
            this.HELP_TEXT.add(ch.getText());
        }
        this.HELP_TEXT.add(ChatColor.GREEN + "-----------------------------------------------------");
    }

    public boolean sendHelp(CommandSender s, CommandArgs args) {
        if (args.getLength() == 1 && (args.getString(0).equalsIgnoreCase("?") || args.getString(0).equalsIgnoreCase("help")) && !this.HELP_TEXT.isEmpty()) {
            for (String string : this.HELP_TEXT) {
                s.sendMessage(string);
            }
            return true;
        }
        return false;
    }

    private class CommandHelp {
        private final String FULL_TEXT;

        public CommandHelp(String cmd, String description) {
            this.FULL_TEXT = ChatColor.GOLD + cmd + ChatColor.GRAY + " - " + description;
        }

        public String getText() {
            return this.FULL_TEXT;
        }
    }
}

