/*
 * Decompiled with CFR 0.152.
 */
package de.JeterLP.ChatManager.Command;

import de.JeterLP.ChatManager.ChatEX;
import de.JeterLP.ChatManager.Command.BaseCommand;
import de.JeterLP.ChatManager.Command.BukkitCommand;
import de.JeterLP.ChatManager.Command.CommandArgs;
import de.JeterLP.ChatManager.Command.CommandHandler;
import de.JeterLP.ChatManager.Command.CommandResult;
import de.JeterLP.ChatManager.Command.MethodContainer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandManager
implements CommandExecutor {
    private final HashMap<BaseCommand, MethodContainer> cmds = new HashMap();
    private final CommandMap cmap;
    private final JavaPlugin plugin;

    public CommandManager(JavaPlugin plugin) {
        CommandMap map;
        this.plugin = plugin;
        try {
            Field f = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            f.setAccessible(true);
            map = (CommandMap)f.get(Bukkit.getServer());
        }
        catch (Exception ex) {
            map = null;
            ex.printStackTrace();
        }
        this.cmap = map;
        ChatEX.debug("Getting CommandMap was " + (this.cmap != null ? "successfull" : "unsuccessfull"));
    }

    private void registerCommand(String name) {
        if (this.cmap.getCommand(name) != null) {
            return;
        }
        BukkitCommand cmd = new BukkitCommand(name);
        this.cmap.register(this.plugin.getName().toLowerCase(), (Command)cmd);
        cmd.setExecutor(this);
        ChatEX.debug("Set executor for " + name);
    }

    private BaseCommand getCommand(Command c, CommandArgs args, BaseCommand.Sender sender) {
        Object ret = null;
        for (BaseCommand bc : this.cmds.keySet()) {
            if (bc.sender() != sender) continue;
            ChatEX.debug("bc.sender() equals sender Line 53");
            if (!bc.command().equalsIgnoreCase(c.getName())) continue;
            ChatEX.debug("bc.command() equals c.getName()! Line 53");
            if (args.isEmpty() && bc.subCommand().trim().isEmpty()) {
                ChatEX.debug("args and subcommand are empty! Line 55");
                ret = bc;
                continue;
            }
            if (args.isEmpty() || !bc.subCommand().equalsIgnoreCase(args.getString(0))) continue;
            ChatEX.debug("args are not empty and matched bc.subCommand() Line 58");
            ret = bc;
        }
        ChatEX.debug("returning \n\n" + (ret != null ? ret.toString() : "null") + " \n\nline 63");
        return ret;
    }

    private Object getCommandObject(Command c, BaseCommand.Sender sender, CommandArgs args) throws Exception {
        BaseCommand bcmd = this.getCommand(c, args, sender);
        if (bcmd == null) {
            for (BaseCommand bc : this.cmds.keySet()) {
                if (bc.sender() != sender || !bc.command().equalsIgnoreCase(c.getName()) || !bc.subCommand().trim().isEmpty()) continue;
                bcmd = bc;
                break;
            }
        }
        ChatEX.debug("returning \n\n" + (bcmd != null ? bcmd.toString() : "null") + " \n\nline 77");
        MethodContainer container = this.cmds.get(bcmd);
        Method me = container.getMethod(sender);
        return me.getDeclaringClass().newInstance();
    }

    public void registerClass(Class<?> clazz) {
        if (!clazz.isAnnotationPresent(CommandHandler.class)) {
            this.plugin.getLogger().severe("Class is no CommandHandler");
            return;
        }
        HashMap<BaseCommand, HashMap> list = new HashMap<BaseCommand, HashMap>();
        for (Method m : clazz.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(BaseCommand.class)) continue;
            ChatEX.debug("BaseCommand is present. Line 98");
            BaseCommand bc = m.getAnnotation(BaseCommand.class);
            this.registerCommand(bc.command());
            if (!list.containsKey(bc)) {
                ChatEX.debug("Putting empty hashmap in list Line 104");
                list.put(bc, new HashMap());
            }
            HashMap map = (HashMap)list.get(bc);
            map.put(bc.sender(), m);
            list.remove(bc);
            list.put(bc, map);
            ChatEX.debug("Putting bc, map in list Line 114");
        }
        for (BaseCommand command : list.keySet()) {
            ChatEX.debug("!!Registering command " + command.command() + " subcmd " + command.subCommand() + "!!");
            HashMap map = (HashMap)list.get(command);
            if (this.cmds.containsKey(command)) {
                MethodContainer container = this.cmds.get(command);
                for (BaseCommand.Sender s : container.getMethodMap().keySet()) {
                    Method m = container.getMethod(s);
                    map.put(s, m);
                }
                this.cmds.remove(command);
            }
            this.cmds.put(command, new MethodContainer(map));
        }
    }

    private Method getMethod(Command c, BaseCommand.Sender sender, CommandArgs args) {
        BaseCommand bcmd = this.getCommand(c, args, sender);
        if (bcmd == null) {
            for (BaseCommand bc : this.cmds.keySet()) {
                if (bc.sender() != sender || !bc.command().equalsIgnoreCase(c.getName()) || !bc.subCommand().trim().isEmpty()) continue;
                bcmd = bc;
                break;
            }
        }
        ChatEX.debug("returning \n\n" + (bcmd != null ? bcmd.toString() : "null") + " \n\nline 144");
        MethodContainer container = this.cmds.get(bcmd);
        Method m = container.getMethod(sender);
        try {
            return m;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private boolean executeCommand(Command c, CommandSender s, String[] args) {
        CommandArgs a;
        BaseCommand.Sender sender = s instanceof Player ? BaseCommand.Sender.PLAYER : BaseCommand.Sender.CONSOLE;
        Method m = this.getMethod(c, sender, a = CommandArgs.getArgs(args, 0));
        if (m != null) {
            CommandResult cr;
            m.setAccessible(true);
            BaseCommand bc = m.getAnnotation(BaseCommand.class);
            if (!bc.subCommand().trim().isEmpty() && bc.subCommand().equalsIgnoreCase(a.getString(0))) {
                a = CommandArgs.getArgs(args, 1);
            }
            try {
                if (sender == BaseCommand.Sender.PLAYER) {
                    Player p = (Player)s;
                    cr = bc.permission() != null && !bc.permission().trim().isEmpty() ? (!p.hasPermission(bc.permission()) ? CommandResult.NO_PERMISSION : (CommandResult)((Object)m.invoke(this.getCommandObject(c, sender, a), p, a))) : (CommandResult)((Object)m.invoke(this.getCommandObject(c, sender, a), p, a));
                } else {
                    cr = (CommandResult)((Object)m.invoke(this.getCommandObject(c, sender, a), s, a));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                cr = CommandResult.SUCCESS;
            }
            if (cr != null && cr.getMessage() != null) {
                String perm = bc.permission() != null ? bc.permission() : "";
                s.sendMessage(cr.getMessage().replace("%cmd%", bc.command()).replace("%perm%", perm));
            }
        } else {
            s.sendMessage("\u00a74The command was not made for your sender type!");
        }
        return true;
    }

    public boolean onCommand(CommandSender cs, Command cmnd, String string, String[] strings) {
        return this.executeCommand(cmnd, cs, strings);
    }
}

