/*
 * Decompiled with CFR 0.152.
 */
package de.JeterLP.ChatManager;

import com.google.common.base.Joiner;
import de.JeterLP.ChatManager.ChatEX;
import de.JeterLP.ChatManager.Command.BaseCommand;
import de.JeterLP.ChatManager.Command.CommandArgs;
import de.JeterLP.ChatManager.Command.CommandHandler;
import de.JeterLP.ChatManager.Command.CommandResult;
import de.JeterLP.ChatManager.Command.HelpPage;
import de.JeterLP.ChatManager.Utils.Locales;
import org.bukkit.Bukkit;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@CommandHandler
public class ChatExCommandHandler {
    private final HelpPage helpPage = new HelpPage("chatex");

    public ChatExCommandHandler() {
        this.helpPage.addPage("reload", Locales.COMMAND_RELOAD_DESCRIPTION.getString());
        this.helpPage.addPage("clear", Locales.COMMAND_CLEAR_DESCRIPTION.getString());
        this.helpPage.prepare();
    }

    @BaseCommand(command="chatex", sender=BaseCommand.Sender.CONSOLE)
    public CommandResult executeConsole(CommandSender sender, CommandArgs args) {
        if (this.helpPage.sendHelp(sender, args)) {
            return CommandResult.SUCCESS;
        }
        if (!args.isEmpty()) {
            return CommandResult.ERROR;
        }
        sender.sendMessage("\u00a7aChatEx plugin by " + Joiner.on((String)", ").join((Iterable)ChatEX.getInstance().getDescription().getAuthors()));
        return CommandResult.SUCCESS;
    }

    @BaseCommand(command="chatex", sender=BaseCommand.Sender.PLAYER)
    public CommandResult executePlayer(Player sender, CommandArgs args) {
        return this.executeConsole((CommandSender)sender, args);
    }

    @BaseCommand(command="chatex", sender=BaseCommand.Sender.CONSOLE, permission="chatex.reload", subCommand="reload")
    public CommandResult executeSubReloadConsole(CommandSender sender, CommandArgs args) {
        Bukkit.getPluginManager().disablePlugin((Plugin)ChatEX.getInstance());
        Bukkit.getPluginManager().enablePlugin((Plugin)ChatEX.getInstance());
        sender.sendMessage(Locales.MESSAGES_RELOAD.getString());
        return CommandResult.SUCCESS;
    }

    @BaseCommand(command="chatex", sender=BaseCommand.Sender.PLAYER, permission="chatex.reload", subCommand="reload")
    public CommandResult executeSubReloadPlayer(Player sender, CommandArgs args) {
        return this.executeSubReloadConsole((CommandSender)sender, args);
    }

    @BaseCommand(command="chatex", sender=BaseCommand.Sender.CONSOLE, permission="chatex.clear", subCommand="clear")
    public CommandResult executeSubClearConsole(CommandSender sender, CommandArgs args) {
        for (int i = 0; i < 25; ++i) {
            Bukkit.broadcastMessage((String)"\n");
        }
        String who = Locales.COMMAND_CLEAR_UNKNOWN.getString();
        if (sender instanceof ConsoleCommandSender || sender instanceof BlockCommandSender) {
            who = Locales.COMMAND_CLEAR_CONSOLE.getString();
        } else if (sender instanceof Player) {
            who = sender.getName();
        }
        Bukkit.broadcastMessage((String)(Locales.MESSAGES_CLEAR.getString() + who));
        return CommandResult.SUCCESS;
    }

    @BaseCommand(command="chatex", sender=BaseCommand.Sender.PLAYER, permission="chatex.clear", subCommand="clear")
    public CommandResult executeSubClearPlayer(Player sender, CommandArgs args) {
        return this.executeSubClearConsole((CommandSender)sender, args);
    }
}

