/*
 * Decompiled with CFR 0.152.
 */
package de.JeterLP.ChatManager;

import de.JeterLP.ChatManager.ChatExCommandHandler;
import de.JeterLP.ChatManager.Command.CommandManager;
import de.JeterLP.ChatManager.Metrics;
import de.JeterLP.ChatManager.Plugins.PermissionsPlugin;
import de.JeterLP.ChatManager.Plugins.PluginManager;
import de.JeterLP.ChatManager.Utils.Config;
import de.JeterLP.ChatManager.Utils.Locales;
import de.JeterLP.ChatManager.Utils.Utils;
import de.JeterLP.ChatManager.update.Updater;
import java.io.File;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChatEX
extends JavaPlugin {
    private static ChatEX INSTANCE;
    private static PluginManager manager;
    private CommandManager cmanager;

    public void onEnable() {
        try {
            INSTANCE = this;
            Config.load();
            ChatEX.debug("Loaded Config!");
            if (!Config.ENABLE.getBoolean()) {
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                this.getLogger().info("disabled, check config!");
                return;
            }
            Locales.load();
            if (!new File(this.getDataFolder(), Config.LOCALE.getString() + "_readme.txt").exists()) {
                ChatEX.debug("Saving readme to " + this.getDataFolder().getAbsolutePath());
                this.saveResource("locales" + File.separator + Config.LOCALE.getString() + "_readme.txt", true);
            }
            manager = new PluginManager();
            ChatEX.debug("Starting Metrics/MCStats...");
            new Metrics((Plugin)this).start();
            ChatEX.debug("Starting updater...");
            Updater u = new Updater(this, 65863, "chatex");
            u.search();
            this.getLogger().info("Successfully hooked into: " + PluginManager.getInstance().getName());
            ChatEX.debug("registering Listener...");
            if (!Utils.registerListener()) {
                this.getLogger().severe("No valid Listener could be found. Please see the reamde.txt for more information.");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            this.cmanager = new CommandManager(this);
            this.cmanager.registerClass(ChatExCommandHandler.class);
            this.getLogger().info("is now enabled!");
        }
        catch (Exception e) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            e.printStackTrace();
        }
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.getLogger().info("is now disabled!");
    }

    public static ChatEX getInstance() {
        return INSTANCE;
    }

    public static PermissionsPlugin getManager() {
        return manager;
    }

    public static void debug(String message) {
        if (!Config.DEBUG.getBoolean()) {
            return;
        }
        String output = "[DEBUG] " + message;
        ChatEX.getInstance().getLogger().info(output);
    }
}

