/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.pr.reports;

import java.util.ArrayList;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.syntax.pr.ProReports;
import org.syntax.pr.reports.Report;
import org.syntax.pr.reports.Status;

public class ReportManager {
    ProReports plugin;
    FileConfiguration config;
    FileConfiguration mconfig;
    private static ReportManager instance = new ReportManager();
    ArrayList<Report> reports = new ArrayList();

    public void setup(ProReports plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.mconfig = plugin.getMessagesConfig();
    }

    private ReportManager() {
    }

    public static ReportManager getInstance() {
        return instance;
    }

    public void add(String reporter, String reported, String message) {
        this.reports.add(new Report(reporter, reported, message));
        this.save(this.get(reporter));
    }

    public void add(String reporter, String reported, String message, Status status) {
        this.reports.add(new Report(reporter, reported, message, status));
        this.save(this.get(reporter));
    }

    public void remove(String reporter) {
        Report r = this.get(reporter);
        if (r == null) {
            return;
        }
        this.save(this.get(reporter));
        this.reports.remove(r);
    }

    public void delete(String reporter) {
        this.remove(reporter);
        this.config.set("Reports." + reporter, null);
        this.plugin.saveConfig();
    }

    public boolean contains(String reporter) {
        Report r = this.get(reporter);
        return r != null;
    }

    public Report get(String reporter) {
        for (Report r : this.reports) {
            if (!r.getReporter().equalsIgnoreCase(reporter)) continue;
            return r;
        }
        return null;
    }

    public void save(Report report) {
        this.config.set("Reports." + report.getReporter() + ".Reporter", (Object)report.getReporter());
        this.config.set("Reports." + report.getReporter() + ".Reported", (Object)report.getReported());
        this.config.set("Reports." + report.getReporter() + ".Message", (Object)report.getMessage());
        this.config.set("Reports." + report.getReporter() + ".Status", (Object)report.getStatus().toString());
        this.plugin.saveConfig();
    }

    public void saveAll() {
        for (Report r : this.reports) {
            if (r == null) continue;
            this.save(r);
        }
    }

    public void load(String reporter) {
        Status status;
        if (!this.config.contains("Reports." + reporter + ".Reporter")) {
            return;
        }
        if (this.contains(reporter)) {
            return;
        }
        String reported = this.config.getString("Reports." + reporter + ".Reported");
        String msg = this.config.getString("Reports." + reporter + ".Message");
        try {
            status = Status.valueOf(this.config.getString("Reports." + reporter + ".Status").toUpperCase());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.add(reporter, reported, msg, status);
    }

    public void loadAll() {
        if (!this.config.contains("Reports.DONOTDELETE")) {
            this.config.set("Reports.DONOTDELETE", (Object)true);
        }
        this.plugin.saveConfig();
        for (String s : this.config.getConfigurationSection("Reports").getKeys(false)) {
            if (s.equalsIgnoreCase("DONOTDELETE") || !this.config.contains("Reports." + s + ".Reported")) continue;
            this.load(s);
        }
    }

    public void showMenuOne(Player p) {
        Inventory inv = Bukkit.createInventory(null, (int)45, (String)(ChatColor.DARK_RED + "Reports Menu"));
        for (Report r : this.reports) {
            ChatColor color = r.getStatus() == Status.IN_PROGRESS ? ChatColor.AQUA : ChatColor.GREEN;
            ItemStack i = new ItemStack(Material.WOOL, 1, (short)(r.getStatus() == Status.IN_PROGRESS ? 3 : 5));
            ItemMeta meta = i.getItemMeta();
            meta.setDisplayName(color + r.getReporter() + "'s report.");
            ArrayList<String> lores = new ArrayList<String>();
            lores.add(ChatColor.DARK_GREEN + "Reporter: " + ChatColor.GREEN + ChatColor.ITALIC + r.getReporter());
            lores.add(ChatColor.DARK_RED + "Reported: " + ChatColor.RED + ChatColor.ITALIC + r.getReported());
            lores.add(ChatColor.DARK_GRAY + "Message: " + ChatColor.GRAY + ChatColor.ITALIC + r.getMessage());
            lores.add((color == ChatColor.AQUA ? ChatColor.DARK_AQUA : ChatColor.DARK_GREEN) + "Status: " + color + ChatColor.ITALIC + WordUtils.capitalizeFully((String)r.getStatus().toString().toLowerCase().replace('_', ' ')));
            meta.setLore(lores);
            i.setItemMeta(meta);
            inv.addItem(new ItemStack[]{i});
        }
        p.openInventory(inv);
    }

    public void showReportMenu(Player p, Report r) {
        String reporter = r.getReporter();
        String reported = r.getReported();
        String message = r.getMessage();
        Status status = r.getStatus();
        Player p_reporter = p.getServer().getPlayer(reporter);
        Player p_reported = p.getServer().getPlayer(reported);
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)(ChatColor.DARK_GRAY + "\u27b8 " + ChatColor.RED + reporter + "'s report."));
        ItemStack i = new ItemStack(Material.SKULL_ITEM, 1, 3);
        SkullMeta smeta = (SkullMeta)i.getItemMeta();
        smeta.setDisplayName(ChatColor.DARK_GREEN + "Reporter: " + ChatColor.GREEN + reporter);
        smeta.setOwner(reporter);
        ArrayList<String> lores = new ArrayList<String>();
        lores.add(p_reporter != null ? ChatColor.DARK_GREEN + "Player is online." : ChatColor.DARK_RED + "Player has disconnected.");
        smeta.setLore(lores);
        i.setItemMeta((ItemMeta)smeta);
        inv.setItem(0, i);
        i = new ItemStack(Material.SKULL_ITEM, 1, 3);
        smeta = (SkullMeta)i.getItemMeta();
        smeta.setDisplayName(ChatColor.DARK_RED + "Reported: " + ChatColor.RED + reported);
        smeta.setOwner(reported);
        lores = new ArrayList();
        lores.add(p_reported != null ? ChatColor.DARK_GREEN + "Player is online." : ChatColor.DARK_RED + "Player has disconnected.");
        smeta.setLore(lores);
        i.setItemMeta((ItemMeta)smeta);
        inv.setItem(1, i);
        i = new ItemStack(Material.PAPER, 1);
        ItemMeta meta = i.getItemMeta();
        meta.setDisplayName(ChatColor.DARK_GRAY + "Message:");
        lores = new ArrayList();
        lores.add(ChatColor.GRAY + message);
        meta.setLore(lores);
        i.setItemMeta(meta);
        inv.setItem(4, i);
        i = new ItemStack(Material.WOOL, 1, (short)(status == Status.IN_PROGRESS ? 3 : 5));
        meta = i.getItemMeta();
        meta.setDisplayName(status == Status.IN_PROGRESS ? ChatColor.AQUA + "This report is still in progress. " + ChatColor.RED + "Player(s) may still be hot headed." : ChatColor.GREEN + "This report has been resolved.");
        lores = new ArrayList();
        lores.add(status == Status.IN_PROGRESS ? ChatColor.AQUA + "Click to set to resolved." : ChatColor.GREEN + "Click to set to in progress again.");
        meta.setLore(lores);
        i.setItemMeta(meta);
        inv.setItem(5, i);
        i = new ItemStack(Material.SIGN, 1);
        meta = i.getItemMeta();
        meta.setDisplayName(ChatColor.DARK_RED + "Go Back");
        lores = new ArrayList();
        meta.setLore(lores);
        i.setItemMeta(meta);
        inv.setItem(7, i);
        i = new ItemStack(Material.BARRIER, 1);
        meta = i.getItemMeta();
        meta.setDisplayName(ChatColor.RED + "Delete Report");
        lores = new ArrayList();
        meta.setLore(lores);
        i.setItemMeta(meta);
        inv.setItem(8, i);
        p.openInventory(inv);
    }

    public void showPlayerActionMenu(Player p, String player, Report r) {
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)(ChatColor.DARK_GRAY + "\u270f " + ChatColor.RED + player));
        ItemStack i = new ItemStack(Material.SKULL_ITEM, 1);
        SkullMeta smeta = (SkullMeta)i.getItemMeta();
        smeta.setDisplayName(ChatColor.RED + "Kill " + player);
        i.setItemMeta((ItemMeta)smeta);
        inv.setItem(0, i);
        i = new ItemStack(Material.BARRIER, 1);
        ItemMeta meta = i.getItemMeta();
        meta.setDisplayName(ChatColor.DARK_RED + "Kick " + player);
        i.setItemMeta(meta);
        inv.setItem(1, i);
        i = new ItemStack(Material.BOOK_AND_QUILL, 1);
        meta = i.getItemMeta();
        meta.setDisplayName(ChatColor.AQUA + "Send pre-formated message to " + player);
        ArrayList<String> lores = new ArrayList<String>();
        lores.add(ChatColor.GOLD + ChatColor.ITALIC + ChatColor.BOLD + "Examples:");
        for (String s : this.mconfig.getStringList("Messages")) {
            lores.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        meta.setLore(lores);
        i.setItemMeta(meta);
        inv.setItem(2, i);
        i = new ItemStack(Material.ENDER_PEARL, 1);
        meta = i.getItemMeta();
        meta.setDisplayName(ChatColor.DARK_GREEN + "Teleport to " + player);
        i.setItemMeta(meta);
        inv.setItem(3, i);
        i = new ItemStack(Material.SIGN, 1);
        meta = i.getItemMeta();
        meta.setDisplayName(ChatColor.DARK_GRAY + "Back to " + r.getReporter() + "'s report");
        i.setItemMeta(meta);
        inv.setItem(8, i);
        p.openInventory(inv);
    }

    public void showPlayerMessageMenu(Player p, String player) {
        ItemMeta meta;
        ItemStack i;
        Inventory inv = Bukkit.createInventory(null, (int)18, (String)(ChatColor.DARK_GRAY + "\u270d " + ChatColor.LIGHT_PURPLE + player));
        int x = 0;
        for (String s : this.mconfig.getStringList("Messages")) {
            if (x >= 17) continue;
            i = new ItemStack(Material.PAPER, 1);
            meta = i.getItemMeta();
            meta.setDisplayName(ChatColor.GREEN + "Send message:");
            ArrayList<String> lores = new ArrayList<String>();
            lores.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
            meta.setLore(lores);
            i.setItemMeta(meta);
            inv.addItem(new ItemStack[]{i});
            ++x;
        }
        i = new ItemStack(Material.SIGN, 1);
        meta = i.getItemMeta();
        meta.setDisplayName(ChatColor.DARK_GRAY + "Back to " + player + "'s menu");
        i.setItemMeta(meta);
        inv.setItem(17, i);
        p.openInventory(inv);
    }
}

