/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.pr.cmds;

import org.apache.commons.lang3.text.WordUtils;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.syntax.pr.ProReports;
import org.syntax.pr.reports.ReportManager;

public class ReportPlayer
implements CommandExecutor {
    ReportManager rm = ReportManager.getInstance();
    ProReports plugin;
    FileConfiguration config;

    public ReportPlayer(ProReports plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
    }

    public boolean onCommand(CommandSender sender, Command command, String cmd, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("You can't run this command, unless you're a player.");
            return false;
        }
        Player p = (Player)sender;
        if (!p.hasPermission("ProReports.report")) {
            p.sendMessage(ChatColor.DARK_RED + "- " + ChatColor.RED + ChatColor.ITALIC + "You do not have permission to use this command.");
            return false;
        }
        if (args.length < 2) {
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("CustomMessage.ReportHelp")));
            return false;
        }
        Player target = p.getServer().getPlayer(args[0]);
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i < args.length) {
            sb.append(String.valueOf(args[i]) + " ");
            ++i;
        }
        String a = sb.toString().trim();
        String reason = WordUtils.capitalize((String)a.toLowerCase());
        if (!(reason.endsWith(".") || reason.endsWith("!") || reason.endsWith("?"))) {
            reason = String.valueOf(reason) + ".";
        }
        for (Player admin : p.getServer().getOnlinePlayers()) {
            if (!admin.hasPermission("ProReports.admin")) continue;
            admin.sendMessage(ChatColor.GREEN + ChatColor.BOLD + ChatColor.ITALIC + "\u2710 New report!");
            admin.playSound(admin.getLocation(), Sound.ORB_PICKUP, 10.0f, 10.0f);
        }
        p.sendMessage(ChatColor.DARK_GRAY + "- " + ChatColor.GOLD + ChatColor.ITALIC + "Player reported! An admin will review it soon.");
        target.sendMessage(ChatColor.DARK_RED + ChatColor.BOLD + ChatColor.ITALIC + "You have been reported! " + ChatColor.GRAY + ChatColor.ITALIC + "An admin is reviewing the case.");
        target.playSound(target.getLocation(), Sound.ORB_PICKUP, 10.0f, 10.0f);
        this.rm.add(p.getName(), target.getName(), reason);
        return false;
    }
}

