/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.pr;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.syntax.pr.cmds.OpenMenu;
import org.syntax.pr.cmds.ReportPlayer;
import org.syntax.pr.listeners.ClickAdminMenu;
import org.syntax.pr.listeners.ClickOnMainMenu;
import org.syntax.pr.listeners.ClickOnMessageMenu;
import org.syntax.pr.listeners.ClickOnReportMenu;
import org.syntax.pr.reports.ReportManager;

public class ProReports
extends JavaPlugin {
    File messageYML;
    FileConfiguration messageConfig;

    public void onEnable() {
        this.messageYML = new File(this.getDataFolder(), "/messages.yml");
        if (!this.messageYML.exists()) {
            try {
                this.messageYML.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.messageConfig = YamlConfiguration.loadConfiguration((File)this.messageYML);
        this.getServer().getPluginManager().registerEvents((Listener)new ClickOnMainMenu(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ClickOnReportMenu(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ClickAdminMenu(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ClickOnMessageMenu(), (Plugin)this);
        this.getCommand("reports").setExecutor((CommandExecutor)new OpenMenu(this));
        this.getCommand("report").setExecutor((CommandExecutor)new ReportPlayer(this));
        ArrayList<String> lores = new ArrayList<String>();
        lores.add("&4Reported actions were justified.");
        lores.add("&bReported player was punished.");
        lores.add("&fYou have been warned, do not do that again.");
        lores.add("&6Report has been handled by an admin.");
        if (!this.getMessagesConfig().contains("Messages")) {
            this.getMessagesConfig().set("Messages", lores);
        }
        this.saveMessagesConfig();
        if (!this.getConfig().contains("Reports.DONOTDELETE")) {
            this.getConfig().set("Reports.DONOTDELETE", (Object)true);
        }
        if (!this.getConfig().contains("CustomMessage.ReportsHelp")) {
            this.getConfig().set("CustomMessage.ReportsHelp", (Object)"&bUsage: /reports");
        }
        if (!this.getConfig().contains("CustomMessage.ReportHelp")) {
            this.getConfig().set("CustomMessage.ReportHelp", (Object)"&bUsage: /report <player> <reason>");
        }
        this.saveConfig();
        ReportManager.getInstance().setup(this);
        ReportManager.getInstance().loadAll();
        this.getServer().getConsoleSender().sendMessage(ChatColor.BLUE + "-> ProReports has been enabled!");
        super.onEnable();
    }

    public void onDisable() {
        ReportManager.getInstance().saveAll();
        this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "-> ProReports has been disabled!");
        super.onDisable();
    }

    public FileConfiguration getMessagesConfig() {
        return this.messageConfig;
    }

    public void saveMessagesConfig() {
        try {
            this.messageConfig.save(this.messageYML);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

