/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.commands.sub;

import io.puharesource.mc.titlemanager.TitleManager;
import io.puharesource.mc.titlemanager.api.TitleObject;
import io.puharesource.mc.titlemanager.api.iface.IAnimation;
import io.puharesource.mc.titlemanager.api.iface.ITitleObject;
import io.puharesource.mc.titlemanager.backend.config.ConfigMain;
import io.puharesource.mc.titlemanager.backend.utils.MiscellaneousUtils;
import io.puharesource.mc.titlemanager.commands.CommandParameter;
import io.puharesource.mc.titlemanager.commands.ParameterSupport;
import io.puharesource.mc.titlemanager.commands.TMSubCommand;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ParameterSupport(supportedParams={"SILENT", "FADEIN", "STAY", "FADEOUT", "WORLD"})
public final class SubBroadcast
extends TMSubCommand {
    public SubBroadcast() {
        super("bc", "titlemanager.command.broadcast", "<message>", "Sends a title message to everyone on the server, put inside of the message, to add a subtitle.", "broadcast");
    }

    @Override
    public void onCommand(CommandSender sender, String[] args, Map<String, CommandParameter> params) {
        String[] stringArray;
        CommandParameter param;
        if (args.length < 1) {
            this.syntaxError(sender);
            return;
        }
        boolean silent = params.containsKey("SILENT");
        ConfigMain config = TitleManager.getInstance().getConfigManager().getConfig();
        int fadeIn = config.welcomeMessageFadeIn;
        int stay = config.welcomeMessageStay;
        int fadeOut = config.welcomeMessageFadeOut;
        World world = null;
        if (params.containsKey("FADEIN") && (param = params.get("FADEIN")).getValue() != null) {
            try {
                fadeIn = Integer.valueOf(param.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (params.containsKey("STAY") && (param = params.get("STAY")).getValue() != null) {
            try {
                stay = Integer.valueOf(param.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (params.containsKey("FADEOUT") && (param = params.get("FADEOUT")).getValue() != null) {
            try {
                fadeOut = Integer.valueOf(param.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (params.containsKey("WORLD") && (param = params.get("WORLD")).getValue() != null) {
            world = Bukkit.getWorld((String)param.getValue());
        }
        String text = MiscellaneousUtils.combineArray(0, args);
        if ((text = text.replaceFirst("[%{][Nn][Ll][%}]", "<nl>")).toLowerCase().contains("<nl>")) {
            stringArray = text.split("(?i)<nl>");
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = text;
            stringArray = stringArray2;
            stringArray2[1] = "";
        }
        String[] lines = stringArray;
        ITitleObject object = MiscellaneousUtils.generateTitleObject(lines[0], lines[1] == null ? "" : lines[1], fadeIn, stay, fadeOut);
        if (!silent) {
            if (object instanceof IAnimation) {
                sender.sendMessage(ChatColor.GREEN + "You have sent a broadcast animation.");
            } else {
                TitleObject titleObject = (TitleObject)object;
                if (titleObject.getSubtitle() != null && !titleObject.getSubtitle().isEmpty()) {
                    sender.sendMessage(ChatColor.GREEN + "You have sent a broadcast with the message \"" + ChatColor.RESET + titleObject.getTitle() + ChatColor.GREEN + "\" \"" + ChatColor.RESET + titleObject.getSubtitle() + ChatColor.GREEN + "\"");
                } else {
                    sender.sendMessage(ChatColor.GREEN + "You have sent a broadcast with the message \"" + ChatColor.RESET + titleObject.getTitle() + ChatColor.GREEN + "\"");
                }
            }
        }
        if (world != null) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.getWorld() != world) continue;
                object.send(player);
            }
        } else {
            object.broadcast();
        }
    }
}

