/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.commands;

import io.puharesource.mc.titlemanager.commands.CommandParameter;
import io.puharesource.mc.titlemanager.commands.ParameterSupport;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public abstract class TMSubCommand {
    private final String alias;
    private final String node;
    private final String usage;
    private final String description;
    private final String[] aliases;
    private final Set<String> supportedParameters;

    public TMSubCommand(String alias, String node, String usage, String description, String ... aliases) {
        this.alias = alias;
        this.node = node;
        this.usage = usage;
        this.description = description;
        this.aliases = aliases;
        this.supportedParameters = new HashSet<String>();
        if (this.getClass().isAnnotationPresent(ParameterSupport.class)) {
            ParameterSupport parameterSupport = this.getClass().getAnnotation(ParameterSupport.class);
            for (String param : parameterSupport.supportedParams()) {
                this.supportedParameters.add(param.toUpperCase().trim());
            }
        }
    }

    public abstract void onCommand(CommandSender var1, String[] var2, Map<String, CommandParameter> var3);

    public void syntaxError(CommandSender sender) {
        sender.sendMessage(ChatColor.RED + "Wrong usage! Correct usage:");
        sender.sendMessage(ChatColor.RED + "   /" + this.getAlias() + " " + this.getUsage());
    }

    public Collection<String> getSupportedParameters() {
        return this.supportedParameters;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getNode() {
        return this.node;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getAliases() {
        return this.aliases;
    }
}

