/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.commands;

import io.puharesource.mc.titlemanager.TitleManager;
import io.puharesource.mc.titlemanager.commands.CommandParameter;
import io.puharesource.mc.titlemanager.commands.TMSubCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;

public final class TMCommand
implements CommandExecutor,
TabCompleter {
    private Map<String, TMSubCommand> commands = new HashMap<String, TMSubCommand>();

    public TMCommand() {
        PluginCommand cmd = TitleManager.getInstance().getCommand("tm");
        cmd.setExecutor((CommandExecutor)this);
        cmd.setTabCompleter((TabCompleter)this);
    }

    public void addSubCommand(TMSubCommand cmd) {
        this.commands.put(cmd.getAlias().toUpperCase(), cmd);
        for (String alias : cmd.getAliases()) {
            this.commands.put(alias.toUpperCase(), cmd);
        }
    }

    private void syntaxError(CommandSender sender) {
        sender.sendMessage(ChatColor.RED + "Wrong usage! Correct usages: ");
        ArrayList<String> aliases = new ArrayList<String>();
        for (TMSubCommand cmd : this.commands.values()) {
            if (aliases.contains(cmd.getAlias().toUpperCase())) continue;
            sender.sendMessage(ChatColor.RED + "    /tm " + cmd.getAlias() + " " + cmd.getUsage() + ChatColor.GRAY + (cmd.getUsage().isEmpty() ? "- " : " - ") + cmd.getDescription());
            aliases.add(cmd.getAlias().toUpperCase());
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("tm")) {
            return false;
        }
        if (args.length >= 1) {
            TMSubCommand subCommand = this.commands.get(args[0].toUpperCase());
            if (subCommand != null) {
                if (sender.hasPermission(subCommand.getNode())) {
                    String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
                    Map<String, CommandParameter> parameters = this.getParameters(subCommand, subArgs);
                    subCommand.onCommand(sender, Arrays.copyOfRange(subArgs, parameters.size(), subArgs.length), parameters);
                } else {
                    sender.sendMessage(ChatColor.RED + "You do not have permission to use that command!");
                }
            } else {
                this.syntaxError(sender);
            }
        } else {
            this.syntaxError(sender);
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> possibilities = new ArrayList<String>();
        if (args.length == 1) {
            for (String sub : this.commands.keySet()) {
                if (!sub.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                possibilities.add(sub.toLowerCase());
            }
        }
        return possibilities.size() <= 0 ? null : possibilities;
    }

    private Map<String, CommandParameter> getParameters(TMSubCommand cmd, String[] args) {
        Collection<String> supportedParameters = cmd.getSupportedParameters();
        HashMap<String, CommandParameter> parameters = new HashMap<String, CommandParameter>();
        for (String arg : args) {
            if (!arg.startsWith("-")) break;
            char[] chars = arg.toCharArray();
            String fullParameter = "";
            for (int i = 1; chars.length > i; ++i) {
                fullParameter = fullParameter + chars[i];
            }
            if (fullParameter.contains("=")) {
                String[] paramValues = fullParameter.split("=", 2);
                String param = paramValues[0].toUpperCase();
                if (!supportedParameters.contains(param)) break;
                parameters.put(param, new CommandParameter(param, paramValues[1]));
                continue;
            }
            String param = fullParameter.toUpperCase();
            if (!supportedParameters.contains(param)) break;
            parameters.put(param, new CommandParameter(param, null));
        }
        return parameters;
    }
}

