/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.backend.utils;

import io.puharesource.mc.titlemanager.Config;
import io.puharesource.mc.titlemanager.TitleManager;
import io.puharesource.mc.titlemanager.api.ActionbarTitleObject;
import io.puharesource.mc.titlemanager.api.TitleObject;
import io.puharesource.mc.titlemanager.api.animations.ActionbarTitleAnimation;
import io.puharesource.mc.titlemanager.api.animations.AnimationFrame;
import io.puharesource.mc.titlemanager.api.animations.FrameSequence;
import io.puharesource.mc.titlemanager.api.animations.TabTitleAnimation;
import io.puharesource.mc.titlemanager.api.animations.TitleAnimation;
import io.puharesource.mc.titlemanager.api.iface.IActionbarObject;
import io.puharesource.mc.titlemanager.api.iface.ITabObject;
import io.puharesource.mc.titlemanager.api.iface.ITitleObject;
import io.puharesource.mc.titlemanager.backend.config.ConfigMain;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public final class MiscellaneousUtils {
    public static String format(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static FrameSequence isValidAnimationString(String text) {
        if (text == null) {
            return null;
        }
        return (text = text.toUpperCase().trim()).startsWith("ANIMATION:") ? Config.getAnimation(text.substring(10)) : null;
    }

    public static String combineArray(int offset, String[] array) {
        StringBuilder sb = new StringBuilder(array[offset]);
        for (int i = offset + 1; array.length > i; ++i) {
            sb.append(" ").append(array[i]);
        }
        return MiscellaneousUtils.format(sb.toString());
    }

    public static String formatNumber(double number) {
        return MiscellaneousUtils.formatNumber(new BigDecimal(number));
    }

    public static String formatNumber(BigDecimal number) {
        ConfigMain config = TitleManager.getInstance().getConfigManager().getConfig();
        if (config.numberFormatEnabled) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
            return new DecimalFormat(config.numberFormat, symbols).format(number);
        }
        return String.valueOf(number.doubleValue());
    }

    public static Player getPlayer(String name) {
        if (!Pattern.matches("^[a-z0-9A-Z_]+", name) && name.length() <= 16) {
            return null;
        }
        Player correctPlayer = Bukkit.getPlayerExact((String)name);
        if (correctPlayer == null) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!StringUtils.containsIgnoreCase((String)player.getName(), (String)name)) continue;
                return player;
            }
        }
        return correctPlayer;
    }

    public static AnimationFrame getFrameFromString(String frame) {
        int fadeIn = -1;
        int stay = -1;
        int fadeOut = -1;
        if ((frame = MiscellaneousUtils.format(frame)).startsWith("[") && frame.length() > 1) {
            char[] chars = frame.toCharArray();
            String timesString = "";
            for (int i = 1; frame.length() > i; ++i) {
                char c = chars[i];
                if (c == ']') {
                    frame = frame.substring(i + 1);
                    break;
                }
                timesString = timesString + chars[i];
            }
            try {
                String[] times = timesString.split(";", 3);
                fadeIn = Integer.valueOf(times[0]);
                stay = Integer.valueOf(times[1]);
                fadeOut = Integer.parseInt(times[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new AnimationFrame(frame, fadeIn, stay, fadeOut);
    }

    public static ITabObject generateTabObject(String header, String footer) {
        FrameSequence headerObject = MiscellaneousUtils.isValidAnimationString(header);
        FrameSequence footerObject = MiscellaneousUtils.isValidAnimationString(footer);
        headerObject = headerObject == null ? MiscellaneousUtils.format(header).replace("\\n", "\n") : headerObject;
        footerObject = footerObject == null ? MiscellaneousUtils.format(footer).replace("\\n", "\n") : footerObject;
        headerObject = headerObject instanceof String ? new FrameSequence(Collections.singletonList(new AnimationFrame((String)((Object)headerObject), 0, 5, 0))) : headerObject;
        footerObject = footerObject instanceof String ? new FrameSequence(Collections.singletonList(new AnimationFrame((String)((Object)footerObject), 0, 5, 0))) : footerObject;
        return new TabTitleAnimation((Object)headerObject, (Object)footerObject);
    }

    public static ITitleObject generateTitleObject(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        Object titleObject = MiscellaneousUtils.isValidAnimationString(title);
        Object subtitleObject = MiscellaneousUtils.isValidAnimationString(subtitle);
        titleObject = titleObject == null ? MiscellaneousUtils.format(title) : titleObject;
        Object object = subtitleObject = subtitleObject == null ? MiscellaneousUtils.format(subtitle) : subtitleObject;
        if (titleObject instanceof FrameSequence || subtitleObject instanceof FrameSequence) {
            return new TitleAnimation(titleObject, subtitleObject);
        }
        return new TitleObject((String)titleObject, (String)subtitleObject).setFadeIn(fadeIn).setStay(stay).setFadeOut(fadeOut);
    }

    public static IActionbarObject generateActionbarObject(String message) {
        FrameSequence messageObject = MiscellaneousUtils.isValidAnimationString(message);
        messageObject = messageObject == null ? MiscellaneousUtils.format(message).replace("\\n", "\n") : messageObject;
        return messageObject instanceof String ? new ActionbarTitleObject((String)((Object)messageObject)) : new ActionbarTitleAnimation(messageObject);
    }
}

