/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.backend.reflections;

import io.puharesource.mc.titlemanager.backend.reflections.ReflectionClass;
import io.puharesource.mc.titlemanager.backend.reflections.managers.ReflectionManager110;
import io.puharesource.mc.titlemanager.backend.reflections.managers.ReflectionManager18;
import io.puharesource.mc.titlemanager.backend.reflections.managers.ReflectionManager183;
import io.puharesource.mc.titlemanager.backend.reflections.managers.ReflectionManagerProtocolHack1718;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public abstract class ReflectionManager {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(v|)[0-9][_.][0-9]+[_.][R0-9]*");
    private static String version;

    public static ReflectionManager createManager() {
        String version = ReflectionManager.getServerVersion();
        if (version.equalsIgnoreCase("v1_10_R1")) {
            return new ReflectionManager110();
        }
        if (version.equalsIgnoreCase("v1_9_R2")) {
            return new ReflectionManager183();
        }
        if (version.equalsIgnoreCase("v1_9_R1")) {
            return new ReflectionManager183();
        }
        if (version.equalsIgnoreCase("v1_8_R3")) {
            return new ReflectionManager183();
        }
        if (version.equalsIgnoreCase("v1_8_R2.")) {
            return new ReflectionManager183();
        }
        if (version.equalsIgnoreCase("v1_8_R1.")) {
            return new ReflectionManager18();
        }
        if (version.equalsIgnoreCase("v1_7_R4.")) {
            return new ReflectionManagerProtocolHack1718();
        }
        return new ReflectionManager110();
    }

    public static String getServerVersion() {
        String version;
        if (ReflectionManager.version != null) {
            return ReflectionManager.version;
        }
        String pkg = Bukkit.getServer().getClass().getPackage().getName();
        String version0 = pkg.substring(pkg.lastIndexOf(".") + 1);
        if (!VERSION_PATTERN.matcher(version0).matches()) {
            version0 = "";
        }
        ReflectionManager.version = !(version = version0).isEmpty() ? version + "." : "";
        return ReflectionManager.version;
    }

    public abstract Map<String, ReflectionClass> getClasses();

    public abstract Object getIChatBaseComponent(String var1);

    public static enum ReflectionType {
        NET_MINECRAFT_SERVER("net.minecraft.server"),
        ORG_BUKKIT_CRAFTBUKKIT("org.bukkit.craftbukkit"),
        ORG_SPIGOTMC("org.spigotmc");

        private String path;

        private ReflectionType(String path) {
            this.path = path;
        }

        public ReflectionClass getReflectionClass(String path) {
            if (this != ORG_SPIGOTMC) {
                String version = ReflectionManager.getServerVersion();
                return new ReflectionClass(this.path + "." + version + path);
            }
            return new ReflectionClass(this.path + "." + path);
        }
    }
}

