/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.backend.reflections;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class ReflectionClass {
    private final Class<?> handle;
    private final String path;

    public ReflectionClass(String path) throws ClassNotFoundException {
        this.handle = Class.forName(path);
        this.path = path;
    }

    public Method getMethod(String methodName, Class<?> ... params) throws NoSuchMethodException {
        block0: for (Method method : this.handle.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != params.length) continue;
            for (int i = 0; method.getParameterTypes().length > i; ++i) {
                if (!method.getParameterTypes()[i].equals(params[i])) continue block0;
            }
            return method;
        }
        throw new NoSuchMethodException("Couldn't find method \"" + methodName + "\" for " + this.handle.getName() + ".");
    }

    public Constructor getConstructor(Class<?> ... params) throws NoSuchMethodException {
        block0: for (Constructor<?> constructor : this.handle.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != params.length) continue;
            for (int i = 0; constructor.getParameterTypes().length > i; ++i) {
                if (constructor.getParameterTypes()[i] != params[i]) continue block0;
            }
            return constructor;
        }
        throw new NoSuchMethodException("Couldn't find constructor for " + this.handle.getName() + ".");
    }

    public Object createInstance(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; objects.length > i; ++i) {
            classes[i] = objects[i].getClass();
        }
        return this.getConstructor(classes).newInstance(objects);
    }

    public Class<?> getInnerClass(String className) {
        return Class.forName(this.path + "$" + className);
    }

    public ReflectionClass getInnerReflectionClass(String className) {
        return new ReflectionClass(this.path + "$" + className);
    }

    public Field getField(String name) {
        return this.handle.getField(name);
    }

    public final Class<?> getHandle() {
        return this.handle;
    }
}

