/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.backend.player;

import io.puharesource.mc.titlemanager.TitleManager;
import io.puharesource.mc.titlemanager.backend.packet.ActionbarTitlePacket;
import io.puharesource.mc.titlemanager.backend.packet.Packet;
import io.puharesource.mc.titlemanager.backend.packet.v1_7.ItemMessagePacket;
import io.puharesource.mc.titlemanager.backend.reflections.ReflectionClass;
import io.puharesource.mc.titlemanager.backend.reflections.ReflectionManager;
import io.puharesource.mc.titlemanager.backend.reflections.managers.ReflectionManagerProtocolHack1718;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import lombok.NonNull;
import org.bukkit.entity.Player;

public final class TMPlayer
implements Comparable<TMPlayer> {
    private final Player player;
    private final Object entityPlayer;
    private final Field pingField;

    public TMPlayer(Player player) {
        this.player = player;
        ReflectionClass craftPlayerClass = ReflectionManager.ReflectionType.ORG_BUKKIT_CRAFTBUKKIT.getReflectionClass("entity.CraftPlayer");
        Object craftPlayer = craftPlayerClass.getHandle().cast(player);
        Method handle = craftPlayer.getClass().getMethod("getHandle", new Class[0]);
        this.entityPlayer = handle.invoke(craftPlayer, new Object[0]);
        this.pingField = this.entityPlayer.getClass().getField("ping");
    }

    public void sendPacket(Packet packet) {
        if (this.isUsing17() && TitleManager.getInstance().getConfigManager().getConfig().legacyClientSupport) {
            if (packet instanceof ActionbarTitlePacket) {
                packet = new ItemMessagePacket(((ActionbarTitlePacket)packet).getText(), this.player, this.player.getInventory().getHeldItemSlot());
            } else if (!(packet instanceof ItemMessagePacket)) {
                packet = null;
            }
        } else if (this.isUsing17()) {
            packet = null;
        } else if (packet instanceof ItemMessagePacket) {
            packet = null;
        }
        if (packet != null && packet.getHandle() != null) {
            Object connection = this.getPlayerConnection();
            ReflectionManager reflectionManager = TitleManager.getInstance().getReflectionManager();
            reflectionManager.getClasses().get("PlayerConnection").getMethod("sendPacket", reflectionManager.getClasses().get("Packet").getHandle()).invoke(connection, packet.getHandle());
        }
    }

    private Object getEntityPlayer() {
        ReflectionClass craftPlayerClass = TitleManager.getInstance().getReflectionManager().getClasses().get("CraftPlayer");
        return craftPlayerClass.getMethod("getHandle", new Class[0]).invoke(craftPlayerClass.getHandle().cast(this.player), new Object[0]);
    }

    private Object getPlayerConnection() {
        return this.entityPlayer.getClass().getField("playerConnection").get(this.getEntityPlayer());
    }

    public boolean isUsing17() {
        if (!(TitleManager.getInstance().getReflectionManager() instanceof ReflectionManagerProtocolHack1718)) {
            return false;
        }
        Object playerConnection = this.getPlayerConnection();
        Object networkManager = playerConnection.getClass().getField("networkManager").get(playerConnection);
        return (Integer)networkManager.getClass().getMethod("getVersion", new Class[0]).invoke(networkManager, new Object[0]) != 47;
    }

    public int getPing() {
        return this.pingField.getInt(this.entityPlayer);
    }

    @Override
    public int compareTo(@NonNull TMPlayer o) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        return this.player.getName().compareToIgnoreCase(o.player.getName());
    }
}

