/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.backend.hooks.specialrules;

import io.puharesource.mc.titlemanager.TitleManager;
import io.puharesource.mc.titlemanager.api.variables.VariableRule;
import io.puharesource.mc.titlemanager.backend.hooks.essentials.EssentialsHook;
import io.puharesource.mc.titlemanager.backend.hooks.supervanish.PremiumVanishHook;
import io.puharesource.mc.titlemanager.backend.hooks.supervanish.SuperVanishHook;
import io.puharesource.mc.titlemanager.backend.hooks.vanishnopacket.VanishNoPacketHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class VanishRule
extends VariableRule {
    @Override
    public boolean rule(Player player) {
        return VanishRule.getEssentials().isEnabled() || VanishRule.getVanishHook().isEnabled() || VanishRule.getSuperVanishHook().isEnabled() || VanishRule.getPremiumVanishHook().isEnabled();
    }

    @Override
    public String[] replace(Player player, String text) {
        return new String[0];
    }

    public static int getOnlinePlayers() {
        int nonVanished = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (VanishRule.getEssentials().isEnabled() && VanishRule.getEssentials().isPlayerVanished(player) || VanishRule.getVanishHook().isEnabled() && VanishRule.getVanishHook().isPlayerVanished(player) || VanishRule.getSuperVanishHook().isEnabled() && VanishRule.getSuperVanishHook().isPlayerVanished(player) || VanishRule.getPremiumVanishHook().isEnabled() && VanishRule.getPremiumVanishHook().isPlayerVanished(player)) continue;
            ++nonVanished;
        }
        return nonVanished;
    }

    private static EssentialsHook getEssentials() {
        return (EssentialsHook)TitleManager.getInstance().getVariableManager().getHook("ESSENTIALS");
    }

    private static VanishNoPacketHook getVanishHook() {
        return (VanishNoPacketHook)TitleManager.getInstance().getVariableManager().getHook("VANISHNOPACKET");
    }

    private static SuperVanishHook getSuperVanishHook() {
        return (SuperVanishHook)TitleManager.getInstance().getVariableManager().getHook("SUPERVANISH");
    }

    private static PremiumVanishHook getPremiumVanishHook() {
        return (PremiumVanishHook)TitleManager.getInstance().getVariableManager().getHook("PREMIUMVANISH");
    }
}

