/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.backend.engine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class Engine {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final Map<Integer, ScheduledFuture<?>> scheduled = new ConcurrentHashMap();
    private final AtomicInteger ids = new AtomicInteger(0);

    public int schedule(final Runnable runnable, int delay) {
        final int id = this.ids.incrementAndGet();
        this.scheduled.put(id, this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                runnable.run();
                Engine.this.scheduled.remove(id);
            }
        }, (long)(delay * 50), TimeUnit.MILLISECONDS));
        return id;
    }

    public int schedule(Runnable runnable, int delay, int period) {
        int id = this.ids.incrementAndGet();
        this.scheduled.put(id, this.scheduler.scheduleAtFixedRate(runnable, delay * 50, period * 50, TimeUnit.MILLISECONDS));
        return id;
    }

    public void cancel(int taskId) {
        if (this.scheduled.containsKey(taskId)) {
            this.scheduled.get(taskId).cancel(false);
            this.scheduled.remove(taskId);
        }
    }

    public void cancelAll() {
        for (ScheduledFuture<?> task : this.scheduled.values()) {
            task.cancel(false);
        }
        this.scheduled.clear();
    }
}

