/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.backend.config;

import io.puharesource.mc.titlemanager.backend.config.ConfigField;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public final class ConfigSerializer {
    public static void saveDefaults(Class<?> clazz, File file, boolean override) throws IllegalAccessException, InvocationTargetException, InstantiationException, IOException {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        Object object = clazz.getConstructors()[0].newInstance(new Object[0]);
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigField.class)) continue;
            ConfigField configField = null;
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (!(annotation instanceof ConfigField)) continue;
                configField = (ConfigField)annotation;
                break;
            }
            if (configField == null) continue;
            try {
                if (!override && config.contains(configField.path())) continue;
                config.set(configField.path(), field.get(object));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        config.save(file);
    }

    public static <T> T deserialize(Class<T> clazz, File file) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        Object object = clazz.getConstructors()[0].newInstance(new Object[0]);
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigField.class)) continue;
            ConfigField configField = null;
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (!(annotation instanceof ConfigField)) continue;
                configField = (ConfigField)annotation;
                break;
            }
            if (configField == null) continue;
            field.set(object, config.get(configField.path()));
        }
        return (T)object;
    }

    public static FileConfiguration serialize(Object object, File file) throws IllegalAccessException {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        for (Field field : object.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigField.class)) continue;
            ConfigField configField = null;
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (!(annotation instanceof ConfigField)) continue;
                configField = (ConfigField)annotation;
                break;
            }
            if (configField == null || config.contains(configField.path())) continue;
            config.set(configField.path(), field.get(object));
        }
        return config;
    }
}

