/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.backend.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigFile {
    private JavaPlugin plugin;
    private File path;
    private File file;
    private String fileName;
    private FileConfiguration config;
    private boolean locatedInJar;

    public ConfigFile(JavaPlugin plugin, File path, String fileName, boolean locatedInJar) {
        this.plugin = plugin;
        this.path = path;
        this.fileName = fileName + ".yml";
        this.file = new File(path, this.fileName);
        this.locatedInJar = locatedInJar;
        this.reload();
    }

    public void reload() {
        if (!this.path.exists()) {
            this.path.mkdirs();
        }
        try {
            if (this.locatedInJar) {
                if (!this.file.exists()) {
                    Files.copy(this.plugin.getResource(this.fileName), this.file.toPath(), new CopyOption[0]);
                }
            } else if (!this.file.exists()) {
                this.file.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void backupToFile(File folder, String fileName) {
        try {
            Files.copy(this.file.toPath(), new File(folder, fileName).toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void regenConfig() {
        if (!this.path.exists()) {
            this.path.mkdir();
        }
        if (this.file.exists()) {
            this.file.delete();
        }
        try {
            if (this.locatedInJar) {
                if (!this.file.exists()) {
                    Files.copy(this.plugin.getResource(this.fileName), this.file.toPath(), new CopyOption[0]);
                }
            } else if (!this.file.exists()) {
                this.file.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public FileConfiguration getCopy() {
        return YamlConfiguration.loadConfiguration((File)this.file);
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

