/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.backend.bungee;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.puharesource.mc.titlemanager.TitleManager;
import io.puharesource.mc.titlemanager.backend.bungee.BungeeServerInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public final class BungeeManager
implements PluginMessageListener {
    private Map<String, BungeeServerInfo> servers = new ConcurrentHashMap<String, BungeeServerInfo>();
    private String currentServer;
    private int onlinePlayers = -1;

    public BungeeManager() {
        Bukkit.getScheduler().runTaskTimer((Plugin)TitleManager.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (TitleManager.getInstance().getConfigManager().getConfig().usingBungeecord) {
                    BungeeManager.this.sendMessage("GetServers");
                    BungeeManager.this.sendMessage("GetServer");
                }
            }
        }, 0L, 200L);
    }

    /*
     * WARNING - void declaration
     */
    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        try {
            String subChannel;
            if (!TitleManager.getInstance().getConfigManager().getConfig().usingBungeecord) {
                return;
            }
            if (!channel.equals("BungeeCord")) {
                return;
            }
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
            switch (subChannel = in.readUTF()) {
                case "GetServers": {
                    HashMap<String, String> newServers = new HashMap<String, String>();
                    for (String newServer : in.readUTF().split(", ")) {
                        newServers.put(newServer.toUpperCase().trim(), newServer);
                    }
                    for (String string : this.servers.keySet()) {
                        if (newServers.containsKey(string.toUpperCase().trim())) continue;
                        this.servers.remove(string.toUpperCase().trim());
                    }
                    for (Map.Entry entry : newServers.entrySet()) {
                        if (!this.servers.containsKey(entry.getKey())) {
                            this.servers.put((String)entry.getKey(), new BungeeServerInfo((String)entry.getValue()));
                        }
                        this.servers.get(entry.getKey()).update();
                    }
                    break;
                }
                case "GetServer": {
                    void var10_21;
                    String server;
                    this.currentServer = server = in.readUTF();
                    if (!this.servers.containsKey(server.toUpperCase().trim())) {
                        this.servers.put(server.toUpperCase().trim(), new BungeeServerInfo(server));
                    }
                    BungeeServerInfo info = this.servers.get(server.toUpperCase().trim());
                    info.setMaxPlayers(Bukkit.getMaxPlayers());
                    info.setPlayerCount(Bukkit.getOnlinePlayers().size());
                    boolean bl = false;
                    if (this.servers.containsKey("ALL")) {
                        int n = this.servers.get("ALL").getPlayerCount();
                    } else {
                        for (BungeeServerInfo serverInfo : this.servers.values()) {
                            var10_20 += serverInfo.getPlayerCount();
                        }
                    }
                    this.onlinePlayers = var10_21;
                    break;
                }
                case "PlayerCount": {
                    void var10_25;
                    String server = in.readUTF();
                    int playerCount = in.readInt();
                    if (!this.servers.containsKey(server.toUpperCase().trim())) {
                        this.servers.put(server.toUpperCase().trim(), new BungeeServerInfo(server));
                    }
                    this.servers.get(server.toUpperCase().trim()).setPlayerCount(playerCount);
                    boolean bl = false;
                    if (this.servers.containsKey("ALL")) {
                        int n = this.servers.get("ALL").getPlayerCount();
                    } else {
                        for (BungeeServerInfo serverInfo : this.servers.values()) {
                            var10_24 += serverInfo.getPlayerCount();
                        }
                    }
                    this.onlinePlayers = var10_25;
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ByteArrayDataOutput createOutput() {
        return ByteStreams.newDataOutput();
    }

    public void sendMessage(String ... args) {
        Iterator players = Bukkit.getOnlinePlayers().iterator();
        if (players.hasNext()) {
            this.sendMessage((Player)players.next(), args);
        }
    }

    public void sendMessage(Player player, String ... args) {
        ByteArrayDataOutput output = this.createOutput();
        for (String arg : args) {
            output.writeUTF(arg);
        }
        player.sendPluginMessage((Plugin)TitleManager.getInstance(), "BungeeCord", output.toByteArray());
    }

    public Map<String, BungeeServerInfo> getServers() {
        return this.servers;
    }

    public int getOnlinePlayers() {
        return this.onlinePlayers;
    }

    public BungeeServerInfo getCurrentServer() {
        return this.currentServer == null ? null : this.servers.get(this.currentServer.toUpperCase().trim());
    }
}

