/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.api.variables;

import io.puharesource.mc.titlemanager.TitleManager;
import io.puharesource.mc.titlemanager.api.variables.Variable;
import io.puharesource.mc.titlemanager.api.variables.VariableReplacer;
import io.puharesource.mc.titlemanager.api.variables.VariableRule;
import io.puharesource.mc.titlemanager.backend.hooks.PluginHook;
import io.puharesource.mc.titlemanager.backend.variables.RegisteredVariable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;

public final class VariableManager {
    private final Map<Integer, VariableReplacer> replacers = new HashMap<Integer, VariableReplacer>();
    private final List<RegisteredVariable> variables = Collections.synchronizedList(new ArrayList());
    private Map<String, PluginHook> hooks = new HashMap<String, PluginHook>();
    private Map<String, VariableRule> rules = new HashMap<String, VariableRule>();

    private void registerMethod(Method method, int replacer, Variable variable) {
        this.variables.add(new RegisteredVariable(method, variable, replacer));
    }

    public void registerVariableReplacer(VariableReplacer replacer) {
        int rReplacer = this.replacers.size();
        this.replacers.put(rReplacer, replacer);
        for (Method method : replacer.getClass().getDeclaredMethods()) {
            Class<?>[] params;
            if (!method.isAnnotationPresent(Variable.class)) continue;
            Variable variable = null;
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                if (!(annotation instanceof Variable)) continue;
                variable = (Variable)annotation;
                break;
            }
            if (variable == null || (params = method.getParameterTypes()).length != 1 && !params[0].equals(Player.class)) continue;
            this.registerMethod(method, rReplacer, variable);
        }
    }

    public void registerHook(String name, PluginHook hook) {
        this.hooks.put(name.toUpperCase().trim(), hook);
    }

    public void registerRule(String name, VariableRule rule) {
        this.rules.put(name.toUpperCase().trim(), rule);
    }

    public PluginHook getHook(String name) {
        return this.hooks.get(name.toUpperCase().trim());
    }

    public VariableRule getRule(String name) {
        return this.rules.get(name.toUpperCase().trim());
    }

    private Pattern getVariablePattern(String var) {
        return Pattern.compile("[{](?i)" + var + "[:]\\d+[,]?(\\d+)?[}]");
    }

    public String replaceText(Player player, String text) {
        for (RegisteredVariable variable : this.variables) {
            VariableRule rule;
            String ruleString;
            PluginHook hook;
            String hookString = variable.getVariable().hook();
            if (!hookString.isEmpty() && (hook = this.hooks.get(hookString.toUpperCase().trim())) != null && !hook.isEnabled() || !(ruleString = variable.getVariable().rule()).isEmpty() && (rule = this.rules.get(ruleString.toUpperCase().trim())) != null && !rule.rule(player)) continue;
            for (String var : variable.getVariable().vars()) {
                String invoked;
                if (TitleManager.getInstance().getConfigManager().getConfig().disabledVariables.contains(var)) continue;
                Matcher matcher = this.getVariablePattern(var).matcher(text);
                int[] dimensions = new int[]{-1, -1};
                boolean found = false;
                if (matcher.find()) {
                    found = true;
                    String varText = text.substring(matcher.start(), matcher.end());
                    String[] parts = varText.split(":");
                    if (parts[1].contains(",")) {
                        String[] strDims = parts[1].split(",", 2);
                        try {
                            dimensions[0] = Integer.parseInt(strDims[0]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            dimensions[1] = Integer.parseInt(strDims[1].substring(0, strDims[1].length() - 1));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        try {
                            dimensions[1] = Integer.parseInt(parts[1].substring(0, parts[1].length() - 1));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (!text.toLowerCase().contains("{" + var.toLowerCase() + "}")) continue;
                try {
                    invoked = variable.invoke(this.replacers.get(variable.getReplacer()), player);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    invoked = "UNSUPPORTED";
                }
                if (!invoked.equals("UNSUPPORTED")) {
                    if (dimensions[0] <= -1) {
                        dimensions[0] = 0;
                    }
                    if (dimensions[1] > invoked.length() || dimensions[1] <= -1) {
                        dimensions[1] = invoked.length();
                    }
                    if (dimensions[0] != 0 || dimensions[1] != invoked.length()) {
                        invoked = invoked.substring(dimensions[0], dimensions[1]);
                    }
                }
                text = text.replaceAll(found ? matcher.pattern().pattern() : "(?i)\\{" + var + "\\}", invoked);
            }
        }
        return text;
    }
}

