/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.api.animations;

import io.puharesource.mc.titlemanager.TitleManager;
import io.puharesource.mc.titlemanager.api.TextConverter;
import io.puharesource.mc.titlemanager.api.TitleObject;
import io.puharesource.mc.titlemanager.api.animations.AnimationFrame;
import io.puharesource.mc.titlemanager.api.animations.FrameSequence;
import io.puharesource.mc.titlemanager.api.iface.IAnimation;
import io.puharesource.mc.titlemanager.api.iface.ITitleObject;
import io.puharesource.mc.titlemanager.backend.engine.Engine;
import io.puharesource.mc.titlemanager.backend.packet.TitlePacket;
import io.puharesource.mc.titlemanager.backend.player.TMPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TitleAnimation
implements IAnimation,
ITitleObject {
    private Object title;
    private Object subtitle;

    public TitleAnimation(FrameSequence title, FrameSequence subtitle) {
        this((Object)title, (Object)subtitle);
    }

    public TitleAnimation(FrameSequence title, String subtitle) {
        this((Object)title, (Object)subtitle);
    }

    public TitleAnimation(String title, FrameSequence subtitle) {
        this((Object)title, (Object)subtitle);
    }

    public TitleAnimation(Object title, Object subtitle) {
        if (title != null && !(title instanceof FrameSequence) && !(title instanceof String)) {
            throw new IllegalArgumentException("The title must be a String or a FrameSequence!");
        }
        if (subtitle != null && !(subtitle instanceof FrameSequence) && !(subtitle instanceof String)) {
            throw new IllegalArgumentException("The subtitle must be a String or a FrameSequence!");
        }
        this.title = title;
        this.subtitle = subtitle;
    }

    @Override
    public void broadcast() {
        this.send(null);
    }

    @Override
    public void send(Player player) {
        Engine engine = TitleManager.getInstance().getEngine();
        int times = 0;
        if (this.title instanceof FrameSequence && this.subtitle instanceof FrameSequence) {
            for (AnimationFrame frame : ((FrameSequence)this.title).getFrames()) {
                engine.schedule(new Task(false, frame, player), times);
                times += frame.getTotalTime();
            }
            times = 0;
            for (AnimationFrame frame : ((FrameSequence)this.subtitle).getFrames()) {
                engine.schedule(new Task(true, frame, player), times);
                times += frame.getTotalTime();
            }
        } else if (this.title instanceof FrameSequence) {
            for (AnimationFrame frame : ((FrameSequence)this.title).getFrames()) {
                engine.schedule(new Task(false, frame, player), times);
                times += frame.getTotalTime();
            }
            FrameSequence sequence = (FrameSequence)this.title;
            engine.schedule(new Task(true, new AnimationFrame((String)this.subtitle, sequence.getFadeIn(), sequence.getStay(), sequence.getFadeOut()), player), 0);
        } else if (this.subtitle instanceof FrameSequence) {
            for (AnimationFrame frame : ((FrameSequence)this.subtitle).getFrames()) {
                engine.schedule(new Task(true, frame, player), times);
                times += frame.getTotalTime();
            }
            FrameSequence sequence = (FrameSequence)this.subtitle;
            engine.schedule(new Task(false, new AnimationFrame((String)this.title, sequence.getFadeIn(), sequence.getStay(), sequence.getFadeOut()), player), 0);
        }
    }

    private class Task
    implements Runnable {
        private boolean isSubtitle;
        private AnimationFrame frame;
        private Player player;

        public Task(boolean isSubtitle, AnimationFrame frame, Player player) {
            this.isSubtitle = isSubtitle;
            this.frame = frame;
            this.player = player;
        }

        @Override
        public void run() {
            if (this.player == null) {
                for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                    this.send(p, this.frame);
                }
            } else {
                this.send(this.player, this.frame);
            }
        }

        private void send(Player p, AnimationFrame frame) {
            if (p != null) {
                TMPlayer tmPlayer = new TMPlayer(p);
                tmPlayer.sendPacket(new TitlePacket(frame.getFadeIn(), frame.getStay() + 1, frame.getFadeOut()));
                tmPlayer.sendPacket(new TitlePacket(this.isSubtitle ? TitleObject.TitleType.SUBTITLE : TitleObject.TitleType.TITLE, TextConverter.setVariables(p, frame.getText())));
            }
        }
    }
}

