/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.api.animations;

import io.puharesource.mc.titlemanager.TitleManager;
import io.puharesource.mc.titlemanager.api.TabTitleObject;
import io.puharesource.mc.titlemanager.api.animations.AnimationFrame;
import io.puharesource.mc.titlemanager.api.animations.FrameSequence;
import io.puharesource.mc.titlemanager.api.iface.IAnimation;
import io.puharesource.mc.titlemanager.api.iface.ITabObject;
import io.puharesource.mc.titlemanager.backend.engine.Engine;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TabTitleAnimation
implements IAnimation,
ITabObject {
    private Object header;
    private Object footer;

    public TabTitleAnimation(FrameSequence header, FrameSequence footer) {
        this((Object)header, (Object)footer);
    }

    public TabTitleAnimation(FrameSequence header, String footer) {
        this((Object)header, (Object)footer);
    }

    public TabTitleAnimation(String header, FrameSequence footer) {
        this((Object)header, (Object)footer);
    }

    public TabTitleAnimation(Object header, Object footer) {
        if (header != null && !(header instanceof FrameSequence) && !(header instanceof String)) {
            throw new IllegalArgumentException("The header must be a String or a FrameSequence!");
        }
        if (footer != null && !(footer instanceof FrameSequence) && !(footer instanceof String)) {
            throw new IllegalArgumentException("The footer must be a String or a FrameSequence!");
        }
        this.header = header;
        this.footer = footer;
    }

    @Override
    public void broadcast() {
        this.send(null);
    }

    @Override
    public void send(Player player) {
        block3: {
            int times;
            Engine engine;
            block4: {
                block2: {
                    engine = TitleManager.getInstance().getEngine();
                    times = 0;
                    if (!(this.header instanceof FrameSequence) || !(this.footer instanceof FrameSequence)) break block2;
                    FrameSequence headerSequence = (FrameSequence)this.header;
                    FrameSequence footerSequence = (FrameSequence)this.footer;
                    MultiTask task = new MultiTask(headerSequence, footerSequence, player);
                    int id = engine.schedule(task, 0, 1);
                    task.setId(id);
                    break block3;
                }
                if (!(this.header instanceof FrameSequence)) break block4;
                for (AnimationFrame frame : ((FrameSequence)this.header).getFrames()) {
                    Task task = new Task(frame.getText(), (String)this.footer, player);
                    int id = engine.schedule(task, times, ((FrameSequence)this.header).getTotalTime());
                    task.setId(id);
                    times += frame.getTotalTime();
                }
                break block3;
            }
            if (!(this.footer instanceof FrameSequence)) break block3;
            for (AnimationFrame frame : ((FrameSequence)this.footer).getFrames()) {
                Task task = new Task((String)this.header, frame.getText(), player);
                int id = engine.schedule(task, times, ((FrameSequence)this.footer).getTotalTime());
                task.setId(id);
                times += frame.getTotalTime();
            }
        }
    }

    private class MultiTask
    implements Runnable {
        private int i;
        private int j;
        private int id;
        private int headerTimeLeft;
        private int footerTimeLeft;
        private AnimationFrame currentHeaderFrame;
        private AnimationFrame currentFooterFrame;
        private FrameSequence header;
        private FrameSequence footer;
        private UUID uuid;

        public MultiTask(FrameSequence header, FrameSequence footer, UUID uuid) {
            this.header = header;
            this.footer = footer;
            this.uuid = uuid;
        }

        public MultiTask(FrameSequence header, FrameSequence footer, Player player) {
            this(header, footer, player == null ? null : player.getUniqueId());
        }

        public void setId(int id) {
            this.id = id;
            TitleManager.addRunningAnimationId(id);
        }

        @Override
        public void run() {
            boolean headerChanged = false;
            boolean footerChanged = false;
            if (this.headerTimeLeft == 0 || this.footerTimeLeft == 0) {
                if (this.headerTimeLeft == 0) {
                    this.currentHeaderFrame = this.header.getFrames().get(this.i);
                    this.headerTimeLeft = this.header.getFrames().get(this.i).getTotalTime();
                    this.i = this.header.getFrames().size() - 1 == this.i ? 0 : ++this.i;
                    headerChanged = true;
                }
                if (this.footerTimeLeft == 0) {
                    this.currentFooterFrame = this.footer.getFrames().get(this.j);
                    this.footerTimeLeft = this.footer.getFrames().get(this.j).getTotalTime();
                    this.j = this.footer.getFrames().size() - 1 == this.j ? 0 : ++this.j;
                    footerChanged = true;
                }
                if (this.uuid == null) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        new TabTitleObject(this.currentHeaderFrame.getText(), this.currentFooterFrame.getText()).send(player);
                    }
                } else {
                    Player player = Bukkit.getPlayer((UUID)this.uuid);
                    if (player != null && player.isOnline()) {
                        new TabTitleObject(this.currentHeaderFrame.getText(), this.currentFooterFrame.getText()).send(player);
                    } else {
                        TitleManager.getInstance().getEngine().cancel(this.id);
                        TitleManager.removeRunningAnimationId(this.id);
                    }
                }
            }
            if (!headerChanged) {
                --this.headerTimeLeft;
            }
            if (!footerChanged) {
                --this.footerTimeLeft;
            }
        }
    }

    private class Task
    implements Runnable {
        private String header;
        private String footer;
        private UUID uuid;
        private int id;

        public Task(String header, String footer, UUID uuid) {
            this.header = header;
            this.footer = footer;
            this.uuid = uuid;
        }

        public Task(String header, String footer, Player player) {
            this(header, footer, player == null ? null : player.getUniqueId());
        }

        public Task(String title, TabTitleObject.Position position, UUID uuid) {
            if (position == TabTitleObject.Position.HEADER) {
                this.header = title;
            } else {
                this.footer = title;
            }
            this.uuid = uuid;
        }

        public Task(String title, TabTitleObject.Position position, Player player) {
            this(title, position, player == null ? null : player.getUniqueId());
        }

        public void setId(int id) {
            this.id = id;
            TitleManager.addRunningAnimationId(id);
        }

        @Override
        public void run() {
            if (this.uuid == null) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (this.header != null && this.footer == null) {
                        new TabTitleObject(this.header, TabTitleObject.Position.HEADER).send(player);
                        continue;
                    }
                    if (this.header == null && this.footer != null) {
                        new TabTitleObject(this.footer, TabTitleObject.Position.FOOTER).send(player);
                        continue;
                    }
                    new TabTitleObject(this.header, this.footer).send(player);
                }
            } else {
                Player player = Bukkit.getPlayer((UUID)this.uuid);
                if (player != null && player.isOnline()) {
                    if (this.header != null && this.footer == null) {
                        new TabTitleObject(this.header, TabTitleObject.Position.HEADER).send(player);
                    } else if (this.header == null && this.footer != null) {
                        new TabTitleObject(this.footer, TabTitleObject.Position.FOOTER).send(player);
                    } else {
                        new TabTitleObject(this.header, this.footer).send(player);
                    }
                } else {
                    TitleManager.getInstance().getEngine().cancel(this.id);
                    TitleManager.removeRunningAnimationId(this.id);
                }
            }
        }
    }
}

