/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.api.animations;

import io.puharesource.mc.titlemanager.TitleManager;
import io.puharesource.mc.titlemanager.api.TextConverter;
import io.puharesource.mc.titlemanager.api.animations.AnimationFrame;
import io.puharesource.mc.titlemanager.api.animations.FrameSequence;
import io.puharesource.mc.titlemanager.api.iface.IActionbarObject;
import io.puharesource.mc.titlemanager.api.iface.IAnimation;
import io.puharesource.mc.titlemanager.backend.packet.ActionbarTitlePacket;
import io.puharesource.mc.titlemanager.backend.player.TMPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ActionbarTitleAnimation
implements IAnimation,
IActionbarObject {
    private FrameSequence title;

    public ActionbarTitleAnimation(FrameSequence title) {
        this.title = title;
    }

    @Override
    public void broadcast() {
        this.send(null);
    }

    @Override
    public void send(Player player) {
        int times = 0;
        for (AnimationFrame frame : this.title.getFrames()) {
            TitleManager.getInstance().getEngine().schedule(new Task(frame, player), times);
            times += frame.getTotalTime();
        }
    }

    private class Task
    implements Runnable {
        private AnimationFrame frame;
        private Player player;

        public Task(AnimationFrame frame, Player player) {
            this.frame = frame;
            this.player = player;
        }

        @Override
        public void run() {
            if (this.player == null) {
                for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                    this.send(p, this.frame);
                }
            } else {
                this.send(this.player, this.frame);
            }
        }

        private void send(Player p, AnimationFrame frame) {
            if (p != null) {
                new TMPlayer(p).sendPacket(new ActionbarTitlePacket(TextConverter.setVariables(p, frame.getText())));
            }
        }
    }
}

