/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.api;

import io.puharesource.mc.titlemanager.TitleManager;
import io.puharesource.mc.titlemanager.api.TextConverter;
import io.puharesource.mc.titlemanager.api.events.TitleEvent;
import io.puharesource.mc.titlemanager.api.iface.ITitleObject;
import io.puharesource.mc.titlemanager.backend.config.ConfigMain;
import io.puharesource.mc.titlemanager.backend.packet.TitlePacket;
import io.puharesource.mc.titlemanager.backend.player.TMPlayer;
import io.puharesource.mc.titlemanager.backend.reflections.ReflectionManager;
import io.puharesource.mc.titlemanager.backend.reflections.managers.ReflectionManagerProtocolHack1718;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TitleObject
implements ITitleObject {
    private String title;
    private String subtitle;
    private int fadeIn = -1;
    private int stay = -1;
    private int fadeOut = -1;

    public TitleObject(String title, TitleType type) {
        if (type == TitleType.TITLE) {
            this.setTitle(title);
        } else if (type == TitleType.SUBTITLE) {
            this.setSubtitle(title);
        }
        this.updateTimes();
    }

    public TitleObject(String title, String subtitle) {
        this.setTitle(title);
        this.setSubtitle(subtitle);
        this.updateTimes();
    }

    private void updateTimes() {
        ConfigMain config = TitleManager.getInstance().getConfigManager().getConfig();
        if (config.usingConfig) {
            return;
        }
        this.fadeIn = config.welcomeMessageFadeIn;
        this.stay = config.welcomeMessageStay;
        this.fadeOut = config.welcomeMessageFadeOut;
    }

    @Override
    public void broadcast() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.send(player);
        }
    }

    @Override
    public void send(Player player) {
        TitleEvent event = new TitleEvent(player, this);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        TMPlayer tmPlayer = new TMPlayer(player);
        tmPlayer.sendPacket(new TitlePacket(this.fadeIn, this.stay, this.fadeOut));
        if (this.title != null) {
            tmPlayer.sendPacket(new TitlePacket(TitleType.TITLE, TextConverter.setVariables(player, this.title)));
        }
        if (this.subtitle != null) {
            tmPlayer.sendPacket(new TitlePacket(TitleType.SUBTITLE, TextConverter.setVariables(player, this.subtitle)));
        }
    }

    public String getTitle() {
        return this.title;
    }

    public TitleObject setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public TitleObject setSubtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public int getFadeIn() {
        return this.fadeIn;
    }

    public TitleObject setFadeIn(int ticks) {
        this.fadeIn = ticks;
        return this;
    }

    public int getStay() {
        return this.stay;
    }

    public TitleObject setStay(int ticks) {
        this.stay = ticks;
        return this;
    }

    public int getFadeOut() {
        return this.fadeOut;
    }

    public TitleObject setFadeOut(int ticks) {
        this.fadeOut = ticks;
        return this;
    }

    public static enum TitleType {
        TITLE(0),
        SUBTITLE(1),
        TIMES(2),
        CLEAR(3),
        RESET(4);

        private final int i;

        private TitleType(int i) {
            this.i = i;
        }

        public Object getHandle() {
            ReflectionManager manager = TitleManager.getInstance().getReflectionManager();
            return manager instanceof ReflectionManagerProtocolHack1718 ? manager.getClasses().get("Action").getHandle().getEnumConstants()[this.i] : manager.getClasses().get("EnumTitleAction").getHandle().getEnumConstants()[this.i];
        }
    }
}

