/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager.api;

import io.puharesource.mc.titlemanager.api.TabTitleCache;
import io.puharesource.mc.titlemanager.api.TextConverter;
import io.puharesource.mc.titlemanager.api.events.TabTitleChangeEvent;
import io.puharesource.mc.titlemanager.api.iface.ITabObject;
import io.puharesource.mc.titlemanager.backend.packet.TabmenuPacket;
import io.puharesource.mc.titlemanager.backend.player.TMPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TabTitleObject
implements ITabObject {
    private String header;
    private String footer;

    public TabTitleObject(String title, Position position) {
        if (position == Position.HEADER) {
            this.setHeader(title);
        } else if (position == Position.FOOTER) {
            this.setFooter(title);
        }
    }

    public TabTitleObject(String header, String footer) {
        this.setHeader(header);
        this.setFooter(footer);
    }

    @Override
    public void broadcast() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.send(player);
        }
    }

    @Override
    public void send(Player player) {
        TabTitleCache titleCache;
        TabTitleChangeEvent event = new TabTitleChangeEvent(player, this);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if ((this.header == null || this.footer == null) && (titleCache = TabTitleCache.getTabTitle(player.getUniqueId())) != null) {
            String footerString;
            String headerString;
            if (this.header == null && (headerString = titleCache.getHeader()) != null) {
                this.setHeader(headerString);
            }
            if (this.footer == null && (footerString = titleCache.getFooter()) != null) {
                this.setFooter(footerString);
            }
        }
        TabTitleCache.addTabTitle(player.getUniqueId(), new TabTitleCache(this.header, this.footer));
        if (this.header == null) {
            this.setHeader("");
        }
        if (this.footer == null) {
            this.setFooter("");
        }
        TMPlayer tmPlayer = new TMPlayer(player);
        tmPlayer.sendPacket(new TabmenuPacket(TextConverter.setVariables(player, this.header), TextConverter.setVariables(player, this.footer)));
    }

    public String getHeader() {
        return this.header;
    }

    public TabTitleObject setHeader(String header) {
        this.header = header == null ? "" : header.replace("\\n", "\n");
        return this;
    }

    public String getFooter() {
        return this.footer;
    }

    public TabTitleObject setFooter(String footer) {
        this.footer = footer == null ? "" : footer.replace("\\n", "\n");
        return this;
    }

    public static enum Position {
        HEADER,
        FOOTER;

    }
}

