/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager;

import com.google.common.collect.ImmutableList;
import io.puharesource.mc.titlemanager.Config;
import io.puharesource.mc.titlemanager.api.variables.VariableManager;
import io.puharesource.mc.titlemanager.backend.bungee.BungeeManager;
import io.puharesource.mc.titlemanager.backend.engine.Engine;
import io.puharesource.mc.titlemanager.backend.hooks.essentials.EssentialsHook;
import io.puharesource.mc.titlemanager.backend.hooks.ezrankslite.EZRanksLiteHook;
import io.puharesource.mc.titlemanager.backend.hooks.placeholderapi.PlaceholderAPIHook;
import io.puharesource.mc.titlemanager.backend.hooks.specialrules.BungeeRule;
import io.puharesource.mc.titlemanager.backend.hooks.specialrules.VanishRule;
import io.puharesource.mc.titlemanager.backend.hooks.supervanish.PremiumVanishHook;
import io.puharesource.mc.titlemanager.backend.hooks.supervanish.SuperVanishHook;
import io.puharesource.mc.titlemanager.backend.hooks.vanishnopacket.VanishNoPacketHook;
import io.puharesource.mc.titlemanager.backend.hooks.vault.VaultHook;
import io.puharesource.mc.titlemanager.backend.hooks.vault.VaultRuleEconomy;
import io.puharesource.mc.titlemanager.backend.hooks.vault.VaultRuleGroups;
import io.puharesource.mc.titlemanager.backend.reflections.ReflectionManager;
import io.puharesource.mc.titlemanager.backend.updatechecker.UpdateManager;
import io.puharesource.mc.titlemanager.backend.variables.replacers.VariablesBungee;
import io.puharesource.mc.titlemanager.backend.variables.replacers.VariablesDefault;
import io.puharesource.mc.titlemanager.backend.variables.replacers.VariablesEZRanksLite;
import io.puharesource.mc.titlemanager.backend.variables.replacers.VariablesVault;
import io.puharesource.mc.titlemanager.commands.TMCommand;
import io.puharesource.mc.titlemanager.commands.sub.SubABroadcast;
import io.puharesource.mc.titlemanager.commands.sub.SubAMessage;
import io.puharesource.mc.titlemanager.commands.sub.SubAnimations;
import io.puharesource.mc.titlemanager.commands.sub.SubBroadcast;
import io.puharesource.mc.titlemanager.commands.sub.SubMessage;
import io.puharesource.mc.titlemanager.commands.sub.SubReload;
import io.puharesource.mc.titlemanager.commands.sub.SubVersion;
import io.puharesource.mc.titlemanager.listeners.ListenerConnection;
import io.puharesource.mc.titlemanager.listeners.ListenerItemSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public final class TitleManager
extends JavaPlugin {
    private static TitleManager instance;
    private Config configManager;
    private ReflectionManager reflectionManager;
    private VariableManager variableManager;
    private BungeeManager bungeeManager;
    private UpdateManager updateManager;
    private Engine engine;
    private static List<Integer> runningAnimations;

    public void onEnable() {
        instance = this;
        this.reflectionManager = ReflectionManager.createManager();
        this.variableManager = new VariableManager();
        this.updateManager = new UpdateManager();
        this.engine = new Engine();
        this.getServer().getPluginManager().registerEvents((Listener)new ListenerConnection(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenerItemSlot(), (Plugin)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.bungeeManager = new BungeeManager();
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)this.bungeeManager);
        TMCommand cmd = new TMCommand();
        cmd.addSubCommand(new SubBroadcast());
        cmd.addSubCommand(new SubMessage());
        cmd.addSubCommand(new SubReload());
        cmd.addSubCommand(new SubABroadcast());
        cmd.addSubCommand(new SubAMessage());
        cmd.addSubCommand(new SubAnimations());
        cmd.addSubCommand(new SubVersion());
        this.variableManager.registerHook("VAULT", new VaultHook());
        this.variableManager.registerHook("ESSENTIALS", new EssentialsHook());
        this.variableManager.registerHook("VANISHNOPACKET", new VanishNoPacketHook());
        this.variableManager.registerHook("SUPERVANISH", new SuperVanishHook());
        this.variableManager.registerHook("PREMIUMVANISH", new PremiumVanishHook());
        this.variableManager.registerHook("EZRANKSLITE", new EZRanksLiteHook());
        this.variableManager.registerHook("PLACEHOLDERAPI", new PlaceholderAPIHook());
        this.variableManager.registerRule("VANISH", new VanishRule());
        this.variableManager.registerRule("VAULT-ECONOMY", new VaultRuleEconomy());
        this.variableManager.registerRule("VAULT-GROUPS", new VaultRuleGroups());
        this.variableManager.registerRule("BUNGEECORD", new BungeeRule());
        this.variableManager.registerVariableReplacer(new VariablesDefault());
        this.variableManager.registerVariableReplacer(new VariablesVault());
        this.variableManager.registerVariableReplacer(new VariablesEZRanksLite());
        this.variableManager.registerVariableReplacer(new VariablesBungee());
        this.configManager = new Config();
        this.configManager.load();
    }

    public void onDisable() {
        this.engine.cancelAll();
        runningAnimations.clear();
    }

    public static List<Integer> getRunningAnimations() {
        return ImmutableList.copyOf(runningAnimations);
    }

    public static void addRunningAnimationId(int id) {
        runningAnimations.add(id);
    }

    public static void removeRunningAnimationId(int id) {
        runningAnimations.remove((Object)id);
    }

    public static TitleManager getInstance() {
        return instance;
    }

    public Config getConfigManager() {
        return this.configManager;
    }

    public ReflectionManager getReflectionManager() {
        return this.reflectionManager;
    }

    public VariableManager getVariableManager() {
        return this.variableManager;
    }

    public BungeeManager getBungeeManager() {
        return this.bungeeManager;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public Engine getEngine() {
        return this.engine;
    }

    static {
        runningAnimations = Collections.synchronizedList(new ArrayList());
    }
}

