/*
 * Decompiled with CFR 0.152.
 */
package io.puharesource.mc.titlemanager;

import io.puharesource.mc.titlemanager.TitleManager;
import io.puharesource.mc.titlemanager.api.animations.AnimationFrame;
import io.puharesource.mc.titlemanager.api.animations.FrameSequence;
import io.puharesource.mc.titlemanager.api.iface.IActionbarObject;
import io.puharesource.mc.titlemanager.api.iface.ITabObject;
import io.puharesource.mc.titlemanager.api.iface.ITitleObject;
import io.puharesource.mc.titlemanager.backend.config.ConfigFile;
import io.puharesource.mc.titlemanager.backend.config.ConfigMain;
import io.puharesource.mc.titlemanager.backend.config.ConfigSerializer;
import io.puharesource.mc.titlemanager.backend.utils.MiscellaneousUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public final class Config {
    private ConfigFile configFile;
    private ConfigFile animationConfigFile;
    private Map<String, FrameSequence> animations = new HashMap<String, FrameSequence>();
    private ITabObject tabTitleObject;
    private ITitleObject welcomeObject;
    private ITitleObject firstWelcomeObject;
    private IActionbarObject actionbarWelcomeObject;
    private IActionbarObject actionbarFirstWelcomeObject;
    private ConfigMain config;

    public void load() {
        TitleManager plugin = TitleManager.getInstance();
        this.configFile = new ConfigFile(plugin, plugin.getDataFolder(), "config", false);
        this.animationConfigFile = new ConfigFile(plugin, plugin.getDataFolder(), "animations", true);
        this.configFile.reload();
        try {
            ConfigSerializer.saveDefaults(ConfigMain.class, this.configFile.getFile(), false);
        }
        catch (IOException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        plugin.reloadConfig();
        this.reload();
    }

    public void reload() {
        for (int i = 0; TitleManager.getRunningAnimations().size() > i; ++i) {
            int id = TitleManager.getRunningAnimations().get(i);
            TitleManager.getInstance().getEngine().cancelAll();
            TitleManager.removeRunningAnimationId(id);
        }
        this.configFile.reload();
        try {
            ConfigSerializer.saveDefaults(ConfigMain.class, this.configFile.getFile(), false);
            this.config = ConfigSerializer.deserialize(ConfigMain.class, this.configFile.getFile());
        }
        catch (IOException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        this.animationConfigFile.reload();
        this.animations.clear();
        for (String str : this.animationConfigFile.getConfig().getKeys(false)) {
            ConfigurationSection section = this.animationConfigFile.getConfig().getConfigurationSection(str);
            ArrayList<AnimationFrame> frames = new ArrayList<AnimationFrame>();
            for (String frame : section.getStringList("frames")) {
                frames.add(MiscellaneousUtils.getFrameFromString(frame));
            }
            this.animations.put(str.toUpperCase().trim(), new FrameSequence(frames));
        }
        if (!this.config.usingConfig) {
            return;
        }
        if (this.config.tabmenuEnabled) {
            this.tabTitleObject = MiscellaneousUtils.generateTabObject(this.config.tabmenuHeader, this.config.tabmenuFooter);
            this.tabTitleObject.broadcast();
        }
        if (this.config.welcomeMessageEnabled) {
            this.welcomeObject = MiscellaneousUtils.generateTitleObject(this.config.welcomeMessageTitle, this.config.welcomeMessageSubtitle, this.config.welcomeMessageFadeIn, this.config.welcomeMessageStay, this.config.welcomeMessageFadeOut);
            this.firstWelcomeObject = MiscellaneousUtils.generateTitleObject(this.config.firstJoinTitle, this.config.firstJoinSubtitle, this.config.welcomeMessageFadeIn, this.config.welcomeMessageStay, this.config.welcomeMessageFadeOut);
        }
        if (this.config.actionbarWelcomeEnabled) {
            this.actionbarWelcomeObject = MiscellaneousUtils.generateActionbarObject(this.config.actionbarWelcomeMessage);
            this.actionbarFirstWelcomeObject = MiscellaneousUtils.generateActionbarObject(this.config.actionbarFirstWelcomeMessage);
        }
        for (int i = 0; this.config.disabledVariables.size() > i; ++i) {
            this.config.disabledVariables.set(i, this.config.disabledVariables.get(i).trim().toLowerCase());
        }
    }

    public static FrameSequence getAnimation(String animation) {
        return animation == null ? null : Config.getAnimations().get(animation.toUpperCase().trim());
    }

    public static Map<String, FrameSequence> getAnimations() {
        return TitleManager.getInstance().getConfigManager().animations;
    }

    public ITabObject getTabTitleObject() {
        return this.tabTitleObject;
    }

    public ITitleObject getWelcomeObject() {
        return this.welcomeObject;
    }

    public ITitleObject getFirstWelcomeObject() {
        return this.firstWelcomeObject;
    }

    public IActionbarObject getActionbarWelcomeObject() {
        return this.actionbarWelcomeObject;
    }

    public IActionbarObject getActionbarFirstWelcomeObject() {
        return this.actionbarFirstWelcomeObject;
    }

    public ConfigMain getConfig() {
        return this.config;
    }
}

