/*
 * Decompiled with CFR 0.152.
 */
package com.statiocraft.xxmicloxx.NoteBlockAPI;

import com.statiocraft.xxmicloxx.NoteBlockAPI.AbstractSong;
import com.statiocraft.xxmicloxx.NoteBlockAPI.FadeType;
import com.statiocraft.xxmicloxx.NoteBlockAPI.Interpolator;
import com.statiocraft.xxmicloxx.NoteBlockAPI.NoteBlockPlayerMain;
import com.statiocraft.xxmicloxx.NoteBlockAPI.SongDestroyingEvent;
import com.statiocraft.xxmicloxx.NoteBlockAPI.SongEndEvent;
import com.statiocraft.xxmicloxx.NoteBlockAPI.SongStoppedEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public abstract class SongPlayer {
    protected AbstractSong song;
    protected boolean playing = false;
    protected short tick = (short)-1;
    protected ArrayList<String> playerList = new ArrayList();
    protected boolean autoDestroy = false;
    protected boolean destroyed = false;
    protected Thread playerThread;
    protected byte fadeTarget = (byte)100;
    protected byte volume;
    protected byte fadeStart = this.volume = (byte)100;
    protected int fadeDuration = 60;
    protected int fadeDone = 0;
    protected FadeType fadeType = FadeType.FADE_LINEAR;
    protected List<Runnable> onDestroy = new ArrayList<Runnable>();

    public SongPlayer(AbstractSong song) {
        this.song = song;
        this.createThread();
    }

    public FadeType getFadeType() {
        return this.fadeType;
    }

    public void setFadeType(FadeType fadeType) {
        this.fadeType = fadeType;
    }

    public byte getFadeTarget() {
        return this.fadeTarget;
    }

    public void setFadeTarget(byte fadeTarget) {
        this.fadeTarget = fadeTarget;
    }

    public byte getFadeStart() {
        return this.fadeStart;
    }

    public void setFadeStart(byte fadeStart) {
        this.fadeStart = fadeStart;
    }

    public int getFadeDuration() {
        return this.fadeDuration;
    }

    public void setFadeDuration(int fadeDuration) {
        this.fadeDuration = fadeDuration;
    }

    public int getFadeDone() {
        return this.fadeDone;
    }

    public void setFadeDone(int fadeDone) {
        this.fadeDone = fadeDone;
    }

    protected void calculateFade() {
        if (this.fadeDone == this.fadeDuration) {
            return;
        }
        double targetVolume = Interpolator.interpLinear(new double[]{0.0, this.fadeStart, this.fadeDuration, this.fadeTarget}, this.fadeDone);
        this.setVolume((byte)targetVolume);
        ++this.fadeDone;
    }

    protected void createThread() {
        this.playerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!SongPlayer.this.destroyed) {
                    long startTime = System.currentTimeMillis();
                    SongPlayer songPlayer = SongPlayer.this;
                    synchronized (songPlayer) {
                        if (SongPlayer.this.playing) {
                            SongPlayer.this.calculateFade();
                            SongPlayer.this.tick = (short)(SongPlayer.this.tick + 1);
                            if (SongPlayer.this.tick > SongPlayer.this.song.getLength()) {
                                SongPlayer.this.playing = false;
                                SongPlayer.this.tick = (short)-1;
                                SongEndEvent event = new SongEndEvent(SongPlayer.this);
                                Bukkit.getPluginManager().callEvent((Event)event);
                                SongPlayer.this.destroy();
                            }
                            for (String s : SongPlayer.this.playerList) {
                                Player p = Bukkit.getPlayerExact((String)s);
                                if (p == null) continue;
                                SongPlayer.this.playTick(p, SongPlayer.this.tick);
                            }
                        }
                    }
                    long duration = System.currentTimeMillis() - startTime;
                    float delayMillis = SongPlayer.this.song.getDelay() * 50.0f;
                    if (!((float)duration < delayMillis)) continue;
                    try {
                        Thread.sleep((long)(delayMillis - (float)duration));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        this.playerThread.setPriority(10);
        this.playerThread.start();
    }

    public List<String> getPlayerList() {
        return Collections.unmodifiableList(this.playerList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(Player p) {
        SongPlayer songPlayer = this;
        synchronized (songPlayer) {
            if (!this.playerList.contains(p.getName())) {
                this.playerList.add(p.getName());
                ArrayList<SongPlayer> songs = NoteBlockPlayerMain.plugin.playingSongs.get(p.getName());
                if (songs == null) {
                    songs = new ArrayList();
                }
                songs.add(this);
                NoteBlockPlayerMain.plugin.playingSongs.put(p.getName(), songs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAutoDestroy() {
        SongPlayer songPlayer = this;
        synchronized (songPlayer) {
            return this.autoDestroy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoDestroy(boolean value) {
        SongPlayer songPlayer = this;
        synchronized (songPlayer) {
            this.autoDestroy = value;
        }
    }

    public abstract void playTick(Player var1, int var2);

    public void destroy() {
        this.destroy(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(boolean b) {
        SongPlayer songPlayer = this;
        synchronized (songPlayer) {
            SongDestroyingEvent event = new SongDestroyingEvent(this);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.destroyed = true;
            this.playing = false;
            this.setTick((short)-1);
            if (b) {
                for (Runnable r : this.onDestroy) {
                    try {
                        r.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        if (this.destroyed) {
            return;
        }
        this.playing = playing;
        if (!playing) {
            SongStoppedEvent event = new SongStoppedEvent(this);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
    }

    public short getTick() {
        return this.tick;
    }

    public void setTick(short tick) {
        this.tick = tick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(Player p) {
        SongPlayer songPlayer = this;
        synchronized (songPlayer) {
            this.playerList.remove(p.getName());
            if (NoteBlockPlayerMain.plugin.playingSongs.get(p.getName()) == null) {
                return;
            }
            ArrayList songs = new ArrayList(NoteBlockPlayerMain.plugin.playingSongs.get(p.getName()));
            songs.remove(this);
            NoteBlockPlayerMain.plugin.playingSongs.put(p.getName(), songs);
            if (this.playerList.isEmpty() && this.autoDestroy) {
                SongEndEvent event = new SongEndEvent(this);
                Bukkit.getPluginManager().callEvent((Event)event);
                this.destroy();
            }
        }
    }

    public byte getVolume() {
        return this.volume;
    }

    public void setVolume(byte volume) {
        this.volume = volume;
    }

    public AbstractSong getSong() {
        return this.song;
    }

    public void callOnDestroy(Runnable runnable) {
        this.onDestroy.add(runnable);
    }
}

