/*
 * Decompiled with CFR 0.152.
 */
package com.statiocraft.xxmicloxx.NoteBlockAPI;

import com.statiocraft.jukebox.Song;
import com.statiocraft.xxmicloxx.NoteBlockAPI.AbstractSong;
import com.statiocraft.xxmicloxx.NoteBlockAPI.Layer;
import com.statiocraft.xxmicloxx.NoteBlockAPI.Note;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class NBSDecoder {
    public static Song parse(File decodeFile) {
        try {
            return NBSDecoder.parse(new FileInputStream(decodeFile), decodeFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AbstractSong parse(InputStream inputStream) {
        return NBSDecoder.parse(inputStream, null);
    }

    private static Song parse(InputStream inputStream, File decodeFile) {
        HashMap<Integer, Layer> layerHashMap = new HashMap<Integer, Layer>();
        try {
            short jumpTicks;
            DataInputStream dis = new DataInputStream(inputStream);
            short length = NBSDecoder.readShort(dis);
            short s = NBSDecoder.readShort(dis);
            String title = NBSDecoder.readString(dis);
            String author = NBSDecoder.readString(dis);
            NBSDecoder.readString(dis);
            String description = NBSDecoder.readString(dis);
            float speed = (float)NBSDecoder.readShort(dis) / 100.0f;
            dis.readBoolean();
            dis.readByte();
            dis.readByte();
            NBSDecoder.readInt(dis);
            NBSDecoder.readInt(dis);
            NBSDecoder.readInt(dis);
            NBSDecoder.readInt(dis);
            NBSDecoder.readInt(dis);
            NBSDecoder.readString(dis);
            int tick = -1;
            while ((jumpTicks = NBSDecoder.readShort(dis)) != 0) {
                short jumpLayers;
                tick = (short)(tick + jumpTicks);
                int layer = -1;
                while ((jumpLayers = NBSDecoder.readShort(dis)) != 0) {
                    layer = (short)(layer + jumpLayers);
                    NBSDecoder.setNote(layer, tick, dis.readByte(), dis.readByte(), layerHashMap);
                }
            }
            int i = 0;
            while (i < s) {
                Layer l = (Layer)layerHashMap.get(i);
                if (l != null) {
                    l.setName(NBSDecoder.readString(dis));
                    l.setVolume(dis.readByte());
                }
                ++i;
            }
            return new Song(speed, layerHashMap, s, length, title, author, description, decodeFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void setNote(int layer, int ticks, byte instrument, byte key, HashMap<Integer, Layer> layerHashMap) {
        Layer l = layerHashMap.get(layer);
        if (l == null) {
            l = new Layer();
            layerHashMap.put(layer, l);
        }
        l.setNote(ticks, new Note(instrument, key));
    }

    private static short readShort(DataInputStream dis) throws IOException {
        int byte1 = dis.readUnsignedByte();
        int byte2 = dis.readUnsignedByte();
        return (short)(byte1 + (byte2 << 8));
    }

    private static int readInt(DataInputStream dis) throws IOException {
        int byte1 = dis.readUnsignedByte();
        int byte2 = dis.readUnsignedByte();
        int byte3 = dis.readUnsignedByte();
        int byte4 = dis.readUnsignedByte();
        return byte1 + (byte2 << 8) + (byte3 << 16) + (byte4 << 24);
    }

    private static String readString(DataInputStream dis) throws IOException {
        int length = NBSDecoder.readInt(dis);
        StringBuilder sb = new StringBuilder(length);
        while (length > 0) {
            char c = (char)dis.readByte();
            if (c == '\r') {
                c = ' ';
            }
            sb.append(c);
            --length;
        }
        return sb.toString();
    }
}

