/*
 * Decompiled with CFR 0.152.
 */
package com.statiocraft.xxmicloxx.NoteBlockAPI;

import java.util.Arrays;

public class Interpolator {
    public static double[] interpLinear(double[] x, double[] y, double[] xi) throws IllegalArgumentException {
        if (x.length != y.length) {
            throw new IllegalArgumentException("X and Y must be the same length");
        }
        if (x.length == 1) {
            throw new IllegalArgumentException("X must contain more than one value");
        }
        double[] dx = new double[x.length - 1];
        double[] dy = new double[x.length - 1];
        double[] slope = new double[x.length - 1];
        double[] intercept = new double[x.length - 1];
        int i = 0;
        while (i < x.length - 1) {
            dx[i] = x[i + 1] - x[i];
            if (dx[i] == 0.0) {
                throw new IllegalArgumentException("X must be montotonic. A duplicate x-value was found");
            }
            if (dx[i] < 0.0) {
                throw new IllegalArgumentException("X must be sorted");
            }
            dy[i] = y[i + 1] - y[i];
            slope[i] = dy[i] / dx[i];
            intercept[i] = y[i] - x[i] * slope[i];
            ++i;
        }
        double[] yi = new double[xi.length];
        int i2 = 0;
        while (i2 < xi.length) {
            if (xi[i2] > x[x.length - 1] || xi[i2] < x[0]) {
                yi[i2] = Double.NaN;
            } else {
                int loc = Arrays.binarySearch(x, xi[i2]);
                if (loc < -1) {
                    loc = -loc - 2;
                    yi[i2] = slope[loc] * xi[i2] + intercept[loc];
                } else {
                    yi[i2] = y[loc];
                }
            }
            ++i2;
        }
        return yi;
    }

    public static double[] interpLinear(long[] x, double[] y, long[] xi) throws IllegalArgumentException {
        double[] xd = new double[x.length];
        int i = 0;
        while (i < x.length) {
            xd[i] = x[i];
            ++i;
        }
        double[] xid = new double[xi.length];
        int i2 = 0;
        while (i2 < xi.length) {
            xid[i2] = xi[i2];
            ++i2;
        }
        return Interpolator.interpLinear(xd, y, xid);
    }

    public static double interpLinear(double[] xy, double xx) {
        if (xy.length % 2 != 0) {
            throw new IllegalArgumentException("XY must be divisible by two.");
        }
        double[] x = new double[xy.length / 2];
        double[] y = new double[x.length];
        int i = 0;
        while (i < xy.length) {
            if (i % 2 == 0) {
                x[i / 2] = xy[i];
            } else {
                y[i / 2] = xy[i];
            }
            ++i;
        }
        return Interpolator.interpLinear(x, y, new double[]{xx})[0];
    }
}

