/*
 * Decompiled with CFR 0.152.
 */
package com.statiocraft.jukebox.fromapi.util;

import com.statiocraft.jukebox.fromapi.util.NumberUtil;
import com.statiocraft.jukebox.fromapi.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionType;

public class ItemUtil {
    @Deprecated
    public static BlockId fromCode(String code) {
        Material m = Material.AIR;
        byte data = 0;
        if (NumberUtil.isInt(code)) {
            m = Material.getMaterial((int)Integer.parseInt(code));
        } else {
            StringBuilder sb1 = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            boolean b = false;
            char[] cArray = code.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (b) {
                    sb2.append(c);
                } else if (c == ':') {
                    b = true;
                } else {
                    sb1.append(c);
                }
                ++n2;
            }
            String s1 = sb1.toString();
            String s2 = sb2.toString();
            if (!NumberUtil.isInteger(s1)) {
                return null;
            }
            m = Material.getMaterial((int)NumberUtil.toInt(s1));
            data = NumberUtil.isByte(s2) ? NumberUtil.toByte(s2) : (byte)0;
        }
        return new BlockId(m, data);
    }

    public static BlockId[] fromCodeList(String code) {
        String[] sa = StringUtil.split(code, ',');
        BlockId[] b = new BlockId[sa.length];
        int n = 0;
        while (n < sa.length) {
            b[n] = ItemUtil.fromCode(sa[n]);
            ++n;
        }
        return b;
    }

    public static ItemStack replaceInName(ItemStack item, String replace, String replacement) {
        return ItemUtil.rename(item, item.getItemMeta().getDisplayName().replaceAll(replace, replacement));
    }

    public static boolean compare(ItemStack item1, ItemStack item2) {
        if (item1 == null || item2 == null) {
            return false;
        }
        if (!item1.isSimilar(item2)) {
            return false;
        }
        int amount = item1.getAmount();
        item1.setAmount(item2.getAmount());
        boolean value = item1.equals((Object)item2);
        item1.setAmount(amount);
        return value;
    }

    public static ItemStack resize(ItemStack item, int amount) {
        ItemStack i = item;
        i.setAmount(amount);
        return i;
    }

    public static ItemStack create(Material material, int amount, byte data, String displayname, String[] lore) {
        if (material == Material.AIR) {
            return new ItemStack(Material.AIR);
        }
        ItemStack item = new MaterialData(material, data).toItemStack(amount);
        ItemMeta itemMeta = item.getItemMeta();
        ArrayList<String> l = new ArrayList<String>();
        if (displayname != null) {
            itemMeta.setDisplayName(displayname);
        }
        String[] stringArray = lore;
        int n = lore.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null) {
                l.add(s);
            }
            ++n2;
        }
        itemMeta.setLore(l);
        item.setItemMeta(itemMeta);
        return item;
    }

    public static ItemStack create(Material material, int amount, String displayname, String[] lore) {
        return ItemUtil.create(material, amount, (byte)0, displayname, lore);
    }

    public static ItemStack create(Material material, int amount, String[] lore) {
        return ItemUtil.create(material, amount, (byte)0, lore);
    }

    public static ItemStack create(Material material, int amount, byte data, String[] lore) {
        return ItemUtil.create(material, amount, data, null, lore);
    }

    public static ItemStack create(Material material, int amount, byte data, String displayname, String lore1, String lore2, String lore3, String lore4) {
        return ItemUtil.create(material, amount, data, displayname, new String[]{lore1, lore2, lore3, lore4});
    }

    public static ItemStack create(Material material) {
        return ItemUtil.create(material, 1, (byte)0, null, null, null, null, null);
    }

    public static ItemStack create(Material material, int amount) {
        return ItemUtil.create(material, amount, (byte)0, null, null, null, null, null);
    }

    public static ItemStack create(Material material, int amount, String displayname) {
        return ItemUtil.create(material, amount, (byte)0, displayname, null, null, null, null);
    }

    public static ItemStack create(Material material, int amount, String displayname, String lore1) {
        return ItemUtil.create(material, amount, (byte)0, displayname, lore1, null, null, null);
    }

    public static ItemStack create(Material material, int amount, String displayname, String lore1, String lore2) {
        return ItemUtil.create(material, amount, (byte)0, displayname, lore1, lore2, null, null);
    }

    public static ItemStack create(Material material, int amount, String displayname, String lore1, String lore2, String lore3) {
        return ItemUtil.create(material, amount, (byte)0, displayname, lore1, lore2, lore3, null);
    }

    public static ItemStack create(Material material, byte data) {
        return ItemUtil.create(material, 1, data, null, null, null, null, null);
    }

    public static ItemStack create(Material material, int amount, byte data) {
        return ItemUtil.create(material, amount, data, null, null, null, null, null);
    }

    public static ItemStack create(Material material, int amount, byte data, String displayname) {
        return ItemUtil.create(material, amount, data, displayname, null, null, null, null);
    }

    public static ItemStack create(Material material, int amount, byte data, String displayname, String lore1) {
        return ItemUtil.create(material, amount, data, displayname, lore1, null, null, null);
    }

    public static ItemStack create(Material material, int amount, byte data, String displayname, String lore1, String lore2) {
        return ItemUtil.create(material, amount, data, displayname, lore1, lore2, null, null);
    }

    public static ItemStack create(Material material, int amount, byte data, String displayname, String lore1, String lore2, String lore3) {
        return ItemUtil.create(material, amount, data, displayname, lore1, lore2, lore3, null);
    }

    public static ItemStack potion(ItemStack item, PotionType potionType) {
        Potion potion = new Potion(potionType);
        potion.apply(item);
        return item;
    }

    public static ItemStack enchant(ItemStack item, Enchantment enchantment1, int level1, Enchantment enchantment2, int level2, Enchantment enchantment3, int level3) {
        ItemMeta itemMeta = item.getItemMeta();
        if (enchantment1 != null) {
            itemMeta.addEnchant(enchantment1, level1, true);
        }
        if (enchantment2 != null) {
            itemMeta.addEnchant(enchantment2, level2, true);
        }
        if (enchantment3 != null) {
            itemMeta.addEnchant(enchantment3, level3, true);
        }
        item.setItemMeta(itemMeta);
        return item;
    }

    public static ItemStack enchant(ItemStack item, Enchantment enchantment1, int level1) {
        return ItemUtil.enchant(item, enchantment1, level1, null, 0, null, 0);
    }

    public static ItemStack enchant(ItemStack item, Enchantment enchantment1, int level1, Enchantment enchantment2, int level2) {
        return ItemUtil.enchant(item, enchantment1, level1, enchantment2, level2, null, 0);
    }

    public static ItemStack recolourLeather(ItemStack item, Color colour) {
        ItemStack i = item;
        if (i.getItemMeta() instanceof LeatherArmorMeta) {
            LeatherArmorMeta lam = (LeatherArmorMeta)i.getItemMeta();
            lam.setColor(colour);
            i.setItemMeta((ItemMeta)lam);
        }
        return i;
    }

    public static ItemStack recolorLeather(ItemStack item, Color color) {
        return ItemUtil.recolourLeather(item, color);
    }

    public static ItemStack rename(ItemStack item, String name) {
        ItemMeta im = item.getItemMeta();
        im.setDisplayName(name);
        item.setItemMeta(im);
        return item;
    }

    public static ItemStack setLore(ItemStack item, List<String> lore) {
        ItemStack i = item;
        ItemMeta im = i.getItemMeta();
        im.setLore(lore);
        i.setItemMeta(im);
        return i;
    }

    public static ItemStack setLore(ItemStack item, String[] lore) {
        ArrayList<String> l = new ArrayList<String>();
        int n = 0;
        while (n < lore.length) {
            l.add(lore[n]);
            ++n;
        }
        return ItemUtil.setLore(item, l);
    }

    public static class BlockId {
        private Material type;
        private byte data;

        public BlockId(Material type, byte data) {
            this.type = type;
            this.data = data;
        }

        public BlockId(Material type) {
            this.type = type;
            this.data = 0;
        }

        public Material getType() {
            return this.type;
        }

        public byte getData() {
            return this.data;
        }

        public ItemStack toItemStack() {
            return this.toItemStack(1);
        }

        public ItemStack toItemStack(int amount) {
            return ItemUtil.create(this.type, amount, this.data);
        }

        public String toCode() {
            return String.valueOf(this.type.getId()) + ":" + this.getData();
        }

        public String toString() {
            return this.toCode();
        }
    }
}

