/*
 * Decompiled with CFR 0.152.
 */
package com.statiocraft.jukebox.fromapi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class Serializer {
    public static byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ObjectOutputStream o = new ObjectOutputStream(b);
        o.writeObject(object);
        return b.toByteArray();
    }

    public static Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream b = new ByteArrayInputStream(bytes);
        ObjectInputStream o = new ObjectInputStream(b);
        return o.readObject();
    }

    public static boolean save(File file, Serializable object) {
        if (!file.exists()) {
            try {
                file.getParentFile().mkdir();
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            byte[] b = Serializer.serialize(object);
            ((OutputStream)out).write(b);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> T load(File file, Class<T> paramClass) {
        try {
            return (T)Serializer.load(file);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Serializable load(File file) {
        if (!file.exists()) {
            return null;
        }
        FileInputStream i = null;
        FilterInputStream in = null;
        try {
            i = new FileInputStream(file);
            in = new DataInputStream(i);
            int n = 0;
            byte[] b = new byte[4096];
            while (true) {
                try {
                    b[n] = ((DataInputStream)in).readByte();
                }
                catch (Exception e) {
                    break;
                }
                ++n;
            }
            Serializable serializable = (Serializable)Serializer.deserialize(b);
            return serializable;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                ((InputStream)i).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

