/*
 * Decompiled with CFR 0.152.
 */
package com.statiocraft.jukebox;

import com.statiocraft.jukebox.Song;
import com.statiocraft.jukebox.scJukeBox;
import com.statiocraft.xxmicloxx.NoteBlockAPI.RadioSongPlayer;
import com.statiocraft.xxmicloxx.NoteBlockAPI.SongPlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bukkit.entity.Player;

public abstract class JukeBox {
    protected final List<Player> p = new ArrayList<Player>();
    protected final Song[] s;
    protected final SongPlayer[] l;
    protected int c = -1;

    public JukeBox(Song ... songs) {
        this(new ArrayList<Song>(Arrays.asList(songs)));
    }

    public JukeBox(List<Song> songs) {
        this.s = new Song[songs.size()];
        int n = 0;
        while (n < this.s.length) {
            int i = new Random().nextInt(songs.size());
            this.s[n] = songs.get(i);
            songs.remove(i);
            ++n;
        }
        this.l = new SongPlayer[this.s.length];
        scJukeBox.registerNewJukebox(this);
        this.next();
    }

    public boolean next() {
        try {
            this.l[this.c].destroy(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (scJukeBox.d()) {
            return false;
        }
        ++this.c;
        if (this.c >= this.s.length) {
            this.destroy();
            return false;
        }
        this.l[this.c] = this.s[this.c].play(this.p, RadioSongPlayer.class);
        this.l[this.c].setAutoDestroy(false);
        this.l[this.c].callOnDestroy(new Runnable(){

            @Override
            public void run() {
                for (Player p : JukeBox.this.p) {
                    JukeBox.this.l[JukeBox.this.c].removePlayer(p);
                }
                JukeBox.this.next();
            }
        });
        return true;
    }

    public void addPlayers(List<Player> players) {
        for (Player p : players) {
            JukeBox j = scJukeBox.getCurrentJukebox(p);
            if (j != null) {
                j.removePlayer(p);
            }
            this.p.add(p);
            this.l[this.c].addPlayer(p);
        }
    }

    public void addPlayer(Player player) {
        this.addPlayers(Arrays.asList(player));
    }

    public void removePlayer(Player player) {
        try {
            this.l[this.c].removePlayer(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.p.remove(player);
    }

    public void removePlayers(List<Player> players) {
        for (Player p : players) {
            this.removePlayer(p);
        }
    }

    public List<Player> listPlayers() {
        return new ArrayList<Player>(this.p);
    }

    protected abstract void onDestroy();

    public void destroy() {
        try {
            this.l[this.c].destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.onDestroy();
        this.removePlayers(this.listPlayers());
        scJukeBox.unregisterJukebox(this);
    }
}

