/*
 * Decompiled with CFR 0.152.
 */
package gyurix.ranktime;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.PreparedStatement;
import java.lang.reflect.Field;
import java.sql.DriverManager;
import java.sql.ResultSet;
import org.bukkit.configuration.ConfigurationSection;

public class MySQLDatabase {
    private final String HOST;
    private final String USERNAME;
    private final String PASSWORD;
    private final String DATABASE;
    private final String TABLE;
    private final int TIMEOUT = 5000;
    private Connection con;

    public MySQLDatabase(ConfigurationSection kf) {
        this.HOST = kf.getString("host");
        this.USERNAME = kf.getString("username");
        this.PASSWORD = kf.getString("password");
        this.TABLE = kf.getString("table");
        this.DATABASE = kf.getString("database");
        try {
            this.openConnection();
            this.command("CREATE TABLE IF NOT EXISTS `" + this.TABLE + "`( `server` text, `name` text, `expire` int, `command` text)");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean openConnection() {
        try {
            this.con = (Connection)DriverManager.getConnection("jdbc:mysql://" + this.HOST + "/" + this.DATABASE + "?autoReconnect=true", this.USERNAME, this.PASSWORD);
            this.con.setAutoReconnect(true);
            this.con.setConnectTimeout(5000);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private Connection getConnection() {
        try {
            if (this.con == null || !this.con.isValid(5000)) {
                this.openConnection();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return this.con;
    }

    public ResultSet querry(String cmd) {
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            st = (PreparedStatement)this.getConnection().prepareStatement(cmd);
            rs = st.executeQuery();
            return rs;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public int update(String cmd) {
        PreparedStatement st = null;
        try {
            st = (PreparedStatement)this.getConnection().prepareStatement(cmd);
            int out = st.executeUpdate();
            return out;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public boolean command(String cmd) {
        PreparedStatement st = null;
        try {
            st = (PreparedStatement)this.getConnection().prepareStatement(cmd);
            boolean out = st.execute();
            return out;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean createTable(String name, Class type) {
        StringBuilder cmd = new StringBuilder();
        cmd.append("CREATE TABLE ").append(name).append(" (");
        for (Field f : type.getFields()) {
            cmd.append("");
        }
        cmd.setLength(cmd.length() - 2);
        cmd.append(");");
        return this.command(cmd.toString());
    }
}

