/*
 * Decompiled with CFR 0.152.
 */
package tk.playerforcehd.shield.utils.update;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import jdk.nashorn.internal.objects.annotations.Getter;
import tk.playerforcehd.shield.utils.update.Version;

public class UpdateChecker {
    private static final Gson GSON = new Gson();
    private String localVersion;
    private String globalVersion;
    private boolean isAvaible;
    private Version version;

    public UpdateChecker(String localVersion) {
        this.localVersion = localVersion;
        this.check();
    }

    public boolean check() {
        try {
            URL url = new URL("http://playerforcehd.tk/api/versionAPI.php?id=2");
            URLConnection urlConnection = url.openConnection();
            urlConnection.setRequestProperty("Accept-Charset", "UTF-8");
            urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
            InputStream inputStream = urlConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.globalVersion = bufferedReader.readLine();
            this.version = (Version)GSON.fromJson(this.globalVersion, Version.class);
            int localInt = this.versionStringToInteger(this.localVersion);
            int globalInt = this.versionStringToInteger(this.version.getVersion());
            if (globalInt > localInt) {
                this.isAvaible = true;
                return true;
            }
            this.isAvaible = false;
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isAvaible = false;
            return false;
        }
    }

    private int versionStringToInteger(String versionString) {
        return Integer.parseInt(versionString.replace(".", ""));
    }

    @Getter
    public String getGlobalVersion() {
        return this.globalVersion;
    }

    @Getter
    public boolean isAvaible() {
        return this.isAvaible;
    }

    @Getter
    public String getLocalVersion() {
        return this.localVersion;
    }

    @Getter
    public Version getVersion() {
        return this.version;
    }
}

