/*
 * Decompiled with CFR 0.152.
 */
package tk.playerforcehd.shield.utils.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.bukkit.plugin.Plugin;
import tk.playerforcehd.shield.utils.Callback;

public class MySQL {
    private ExecutorService executorService;
    private Plugin connectionOwner;
    private String host;
    private String port;
    private String user;
    private String password;
    private String database;
    private Connection connection = null;

    public MySQL(Plugin plugin, String host, String port, String database, String username, String password) {
        this.host = host;
        this.port = port;
        this.database = database;
        this.user = username;
        this.password = password;
        this.connectionOwner = plugin;
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)new BasicThreadFactory.Builder().namingPattern(plugin.getName() + "-MySQL-%d").build());
    }

    public boolean connect() {
        if (!this.isConnected()) {
            this.connectionOwner.getLogger().info("Connecting to database: " + this.database);
            int i = 1;
            while (true) {
                try {
                    if (this.executeConnect()) break;
                    if (i != 3) {
                        this.connectionOwner.getLogger().warning("Failed to connect to database, retrying " + i + "/3");
                    } else {
                        this.connectionOwner.getLogger().severe("Failed to connect to the Database 3 times!");
                        this.connectionOwner.getLogger().severe("Stop trying to connect to the database...");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    if (i != 3) {
                        this.connectionOwner.getLogger().warning("Failed to connect to database, retrying " + i + "/3");
                    }
                    this.connectionOwner.getLogger().severe("Failed to connect to the Database 3 times!");
                    this.connectionOwner.getLogger().severe("Stop trying to connect to the database...");
                }
                ++i;
            }
            this.connectionOwner.getLogger().info("Successfully connected to the Database: " + this.database);
            return true;
        }
        return false;
    }

    private boolean executeConnect() throws SQLException {
        this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database, this.user, this.password);
        return this.isConnected();
    }

    public boolean disconnect() {
        if (this.isConnected()) {
            try {
                this.connectionOwner.getLogger().info("Disconnecting from Database: " + this.database + "...");
                this.connection.close();
                this.connectionOwner.getLogger().info("Successfully closed database connection!");
                return true;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public boolean isConnected() {
        try {
            if (this.connection == null) {
                return false;
            }
            return this.connection.isValid(100);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void executeUpdate(final PreparedStatement preparedStatement) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (!MySQL.this.isConnected()) {
                    MySQL.this.connectionOwner.getLogger().warning("The connection has closed, and the plugin tries to execute a MySQL query!");
                    MySQL.this.connectionOwner.getLogger().warning("Try to reconnect 3 times!");
                    MySQL.this.connect();
                }
                try {
                    preparedStatement.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void executeUpdate(final String query) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (!MySQL.this.isConnected()) {
                    MySQL.this.connectionOwner.getLogger().warning("The connection has closed, and the plugin tries to execute a MySQL query!");
                    MySQL.this.connectionOwner.getLogger().warning("Try to reconnect 3 times!");
                    MySQL.this.connect();
                }
                try {
                    MySQL.this.connection.prepareStatement(query).executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void executeQuery(final PreparedStatement preparedStatement, final Callback<ResultSet> callback) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (!MySQL.this.isConnected()) {
                    MySQL.this.connectionOwner.getLogger().warning("The connection has closed, and the plugin tries to execute a MySQL query!");
                    MySQL.this.connectionOwner.getLogger().warning("Try to reconnect 3 times!");
                    MySQL.this.connect();
                }
                try {
                    callback.invoke(preparedStatement.executeQuery());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    callback.invoke(null);
                }
            }
        });
    }

    public void executeQuery(final String query, final Callback<ResultSet> callback) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (!MySQL.this.isConnected()) {
                    MySQL.this.connectionOwner.getLogger().warning("The connection has closed, and the plugin tries to execute a MySQL query!");
                    MySQL.this.connectionOwner.getLogger().warning("Try to reconnect 3 times!");
                    MySQL.this.connect();
                }
                try {
                    callback.invoke(MySQL.this.connection.prepareStatement(query).executeQuery());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    callback.invoke(null);
                }
            }
        });
    }

    public PreparedStatement getPreparedStatement(String qry) {
        try {
            return this.getConnection().prepareStatement(qry);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

