/*
 * Decompiled with CFR 0.152.
 */
package tk.playerforcehd.shield.utils;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.LinkedList;
import java.util.List;
import jdk.nashorn.internal.objects.annotations.Getter;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import tk.playerforcehd.shield.Main;

public class WorldGuardWrapper {
    private static WorldGuardWrapper worldGuardWrapper;
    private WorldGuardPlugin worldGuardPlugin;

    public WorldGuardWrapper() {
        worldGuardWrapper = this;
    }

    @Getter
    public static WorldGuardWrapper getWorldGuardWrapper() {
        return worldGuardWrapper;
    }

    public boolean hook() {
        if (Bukkit.getPluginManager().isPluginEnabled("WorldGuard")) {
            this.worldGuardPlugin = (WorldGuardPlugin)Bukkit.getPluginManager().getPlugin("WorldGuard");
            return true;
        }
        return false;
    }

    public boolean isPlayerInDisabledRegion(Player player) {
        RegionManager regionManager = this.worldGuardPlugin.getRegionManager(player.getWorld());
        ApplicableRegionSet applicableRegionSet = regionManager.getApplicableRegions(player.getLocation());
        LinkedList<String> parent = new LinkedList<String>();
        LinkedList<String> regions = new LinkedList<String>();
        for (ProtectedRegion region : applicableRegionSet) {
            String id = region.getId();
            regions.add(id);
            for (ProtectedRegion parentRegion = region.getParent(); parentRegion != null; parentRegion = parentRegion.getParent()) {
                parent.add(parentRegion.getId());
            }
        }
        for (String name : parent) {
            regions.remove(name);
        }
        List<String> disabledRegions = Main.getInstance().getDataReader().getDisabledRegions();
        for (String region : regions) {
            if (!disabledRegions.contains(region)) continue;
            return true;
        }
        return false;
    }

    @Getter
    public WorldGuardPlugin getWorldGuardPlugin() {
        return this.worldGuardPlugin;
    }
}

