/*
 * Decompiled with CFR 0.152.
 */
package tk.playerforcehd.shield.utils;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;

public class GeoUtils {
    public static List<Location> getCubeAround(Location loca, double cubeSize, double distance) {
        double cubeSizeNeg;
        ArrayList<Location> cubeLocs = new ArrayList<Location>();
        for (double ix = cubeSizeNeg = 0.0 - cubeSize; ix < cubeSize; ix += distance) {
            for (double iy = cubeSizeNeg; iy < cubeSize; iy += distance) {
                for (double iz = cubeSizeNeg; iz < cubeSize; iz += distance) {
                    double e = (double)((int)loca.getX()) + ix;
                    double f = (double)((int)loca.getY()) + iy;
                    double g = (double)((int)loca.getZ()) + iz;
                    cubeLocs.add(new Location(loca.getWorld(), e, f, g));
                }
            }
        }
        return cubeLocs;
    }

    public static List<Location> getCircleRissArround(Location loc, double radius, double distance) {
        ArrayList<Location> circleLocs = new ArrayList<Location>();
        for (double i = 0.0; i < radius * Math.PI; i += distance) {
            Location newLoc = loc.clone();
            newLoc = newLoc.add(radius * Math.cos(i), 0.0, radius * Math.sin(i));
            circleLocs.add(newLoc);
        }
        return circleLocs;
    }

    public static List<Location> getFilledCircle(Location loc, double radius, double distance) {
        ArrayList<Location> circleLocs = new ArrayList<Location>();
        for (double x = -radius; x <= radius; x += distance) {
            for (double z = -radius; z <= radius; z += distance) {
                if (!(x * x + z * z <= radius * radius)) continue;
                circleLocs.add(new Location(loc.getWorld(), loc.getX() + x, loc.getY(), loc.getZ() + z));
            }
        }
        return circleLocs;
    }

    public static List<Location> getFilledCyl(Location loc, int radius, int height) {
        ArrayList<Location> circleLocs = new ArrayList<Location>();
        int fY = loc.getBlockY() + height;
        for (int y = loc.getBlockY(); y < fY; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + z * z > radius * radius) continue;
                    circleLocs.add(new Location(loc.getWorld(), (double)x, (double)y, (double)z));
                }
            }
        }
        return circleLocs;
    }

    public static List<Location> getSphereArround(Location loc, double radius, boolean hollow, double distanze) {
        ArrayList<Location> sphereList = new ArrayList<Location>();
        double lX = loc.getX();
        double lY = loc.getY();
        double lZ = loc.getZ();
        for (double x = lX - radius; x <= lX + radius; x += distanze) {
            for (double y = lY - radius; y <= lY + radius; y += distanze) {
                for (double z = lZ - radius; z <= lZ + radius; z += distanze) {
                    double distance = (lX - x) * (lX - x) + (lZ - z) * (lZ - z) + (lY - y) * (lY - y);
                    if (!(distance < radius * radius) || hollow && distance < (radius - 1.0) * (radius - 1.0)) continue;
                    Location newLoc = new Location(loc.getWorld(), x, y, z);
                    sphereList.add(newLoc);
                }
            }
        }
        return sphereList;
    }
}

