/*
 * Decompiled with CFR 0.152.
 */
package tk.playerforcehd.shield.listener;

import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.util.Vector;
import tk.playerforcehd.shield.Main;
import tk.playerforcehd.shield.compatibility.CompatibilityManager;
import tk.playerforcehd.shield.compatibility.CompatibilityModule;
import tk.playerforcehd.shield.compatibility.modules.citizens.CitizensCompatibilityWorker;
import tk.playerforcehd.shield.utils.TitleUtil;
import tk.playerforcehd.shield.utils.WorldGuardWrapper;

public class MoveFactory
implements Listener {
    private boolean isCitizensPluggedIn;
    private CompatibilityModule citizensModule;

    public MoveFactory() {
        this.makeUpdate();
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        for (Player players : Main.getShieldUsers()) {
            CitizensCompatibilityWorker citizensCompatibilityWorker;
            if (p == players || p.hasPermission("shield.bypass") || !(p.getLocation().distance(players.getLocation()) <= (double)Main.getInstance().getDataReader().getRadius()) || !players.hasPermission("shield.use")) continue;
            if (Main.getInstance().getDataReader().isDisable_pushback()) {
                if (!Main.getInstance().isPermittedByMultiWorld(players)) {
                    return;
                }
                if (Main.getInstance().isWorldGuardHoooked() && Main.getInstance().getDataReader().isEnableWorldGuard() && WorldGuardWrapper.getWorldGuardWrapper().isPlayerInDisabledRegion(players)) {
                    return;
                }
            }
            if (Main.getInstance().getDataReader().isEnableCompatibilityMode() && this.isCitizensPluggedIn && (citizensCompatibilityWorker = (CitizensCompatibilityWorker)this.citizensModule.getCompatibilityWorker()).isCitizensNPC((Entity)p)) {
                return;
            }
            double Ax = p.getLocation().getX();
            double Ay = p.getLocation().getY();
            double Az = p.getLocation().getZ();
            double Bx = players.getLocation().getX();
            double By = players.getLocation().getY();
            double Bz = players.getLocation().getZ();
            double x = Ax - Bx;
            double y = Ay - By;
            double z = Az - Bz;
            Vector v = new Vector(x, y, z).normalize().multiply(Main.getInstance().getDataReader().getMultiply_push()).setY(Main.getInstance().getDataReader().getGrow_y());
            p.setVelocity(v);
            this.sendTitle(p);
            p.playSound(p.getLocation(), Main.getInstance().getDataReader().getSound(), 2.0f, (float)Main.getInstance().getDataReader().getPushSoundPitch());
        }
        if (Main.getShieldUsers().contains(p)) {
            if (Main.getInstance().getDataReader().isDisable_pushback()) {
                if (!Main.getInstance().isPermittedByMultiWorld(p)) {
                    return;
                }
                if (Main.getInstance().isWorldGuardHoooked() && Main.getInstance().getDataReader().isEnableWorldGuard() && WorldGuardWrapper.getWorldGuardWrapper().isPlayerInDisabledRegion(p)) {
                    return;
                }
            }
            for (Entity entity : p.getNearbyEntities((double)Main.getInstance().getDataReader().getRadius(), (double)Main.getInstance().getDataReader().getRadius(), (double)Main.getInstance().getDataReader().getRadius())) {
                CitizensCompatibilityWorker citizensCompatibilityWorker;
                Player target;
                if (!(entity instanceof Player) || p == (target = (Player)entity) || target.hasPermission("shield.bypass") || !p.hasPermission("shield.use")) continue;
                if (Main.getInstance().getDataReader().isEnableCompatibilityMode() && this.isCitizensPluggedIn && (citizensCompatibilityWorker = (CitizensCompatibilityWorker)this.citizensModule.getCompatibilityWorker()).isCitizensNPC((Entity)target)) {
                    return;
                }
                double Ax = p.getLocation().getX();
                double Ay = p.getLocation().getY();
                double Az = p.getLocation().getZ();
                double Bx = target.getLocation().getX();
                double By = target.getLocation().getY();
                double Bz = target.getLocation().getZ();
                double x = Bx - Ax;
                double y = By - Ay;
                double z = Bz - Az;
                Vector v = new Vector(x, y, z).normalize().multiply(Main.getInstance().getDataReader().getMultiply_push()).setY(Main.getInstance().getDataReader().getGrow_y());
                target.setVelocity(v);
                this.sendTitle(target);
                target.playSound(target.getLocation(), Main.getInstance().getDataReader().getSound(), 2.0f, (float)Main.getInstance().getDataReader().getPushSoundPitch());
            }
        }
    }

    public void makeUpdate() {
        for (CompatibilityModule compatibilityModule : Main.getInstance().getCompatibilityManager().getLoadedModules()) {
            if (!compatibilityModule.getModuleName().equalsIgnoreCase(CompatibilityManager.CompatiblePlugins.Citizens.toString())) continue;
            this.isCitizensPluggedIn = true;
            this.citizensModule = compatibilityModule;
            return;
        }
        this.isCitizensPluggedIn = false;
    }

    private void sendTitle(Player player) {
        if (Main.getInstance().getDataReader().isEnablePuchBackTitle()) {
            TitleUtil titleUtil = new TitleUtil(Main.getInstance().getDataReader().getPushBackTitle().replace('&', '\u00a7'), Main.getInstance().getDataReader().getPushBackSubTitle().replace('&', '\u00a7'), Main.getInstance().getDataReader().getPushBackTitleFadeIn(), Main.getInstance().getDataReader().getPushBackTitleStay(), Main.getInstance().getDataReader().getPushBackTitleFadeOut());
            titleUtil.send(player);
        }
    }
}

