/*
 * Decompiled with CFR 0.152.
 */
package tk.playerforcehd.shield.effect.effects;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import tk.playerforcehd.shield.DataReader;
import tk.playerforcehd.shield.Main;
import tk.playerforcehd.shield.effect.Effect;
import tk.playerforcehd.shield.utils.GeoUtils;
import tk.playerforcehd.shield.utils.math.VectorUtils;

public class CubeEffect
extends Effect {
    public CubeEffect() {
        super(DataReader.EffectType.CUBE);
    }

    @Override
    public void calc(Player player) {
        List<Location> locations = null;
        if (Main.getInstance().getDataReader().isHollow()) {
            this.calcStrips(player);
            this.calcWalls(player);
        } else {
            locations = GeoUtils.getCubeAround(this.getBaseEyeLocation(player), Main.getInstance().getDataReader().getRadius(), Main.getInstance().getDataReader().getCircleDistance());
            this.displayParticles(locations);
        }
    }

    private void calcStrips(Player player) {
        float a = (float)(this.getBaseRadius() / 2.0);
        Location location = this.getBaseEyeLocation(player);
        Vector v = new Vector();
        for (int i = 0; i < 4; ++i) {
            double angleY = (double)i * Math.PI / 2.0;
            for (int j = 0; j < 2; ++j) {
                double angleX = (double)j * Math.PI;
                for (int p = 0; p <= Main.getInstance().getDataReader().getParticle_amount(); ++p) {
                    v.setX(a).setY(a);
                    v.setZ(this.getBaseRadius() * (double)p / (double)Main.getInstance().getDataReader().getParticle_amount() - (double)a);
                    VectorUtils.rotateAroundAxisX(v, angleX);
                    VectorUtils.rotateAroundAxisY(v, angleY);
                    this.displayParticles(Arrays.asList(location.add(v)));
                    location.subtract(v);
                }
            }
            for (int p = 0; p <= Main.getInstance().getDataReader().getParticle_amount(); ++p) {
                v.setX(a).setZ(a);
                v.setY(this.getBaseRadius() * (double)p / (double)Main.getInstance().getDataReader().getParticle_amount() - (double)a);
                VectorUtils.rotateAroundAxisY(v, angleY);
                this.displayParticles(Arrays.asList(location.add(v)));
                location.subtract(v);
            }
        }
    }

    private void calcWalls(Player player) {
        Location location = this.getBaseEyeLocation(player);
        float a = (float)(this.getBaseRadius() / 2.0);
        for (int x = 0; x <= Main.getInstance().getDataReader().getParticle_amount(); ++x) {
            float posX = (float)(this.getBaseRadius() * (double)((float)x / (float)Main.getInstance().getDataReader().getParticle_amount()) - (double)a);
            for (int y = 0; y <= Main.getInstance().getDataReader().getParticle_amount(); ++y) {
                float posY = (float)(this.getBaseRadius() * (double)((float)y / (float)Main.getInstance().getDataReader().getParticle_amount()) - (double)a);
                for (int z = 0; z <= Main.getInstance().getDataReader().getParticle_amount(); ++z) {
                    if (x != 0 && x != Main.getInstance().getDataReader().getParticle_amount() && y != 0 && y != Main.getInstance().getDataReader().getParticle_amount() && z != 0 && z != Main.getInstance().getDataReader().getParticle_amount()) continue;
                    float posZ = (float)(this.getBaseRadius() * (double)((float)z / (float)Main.getInstance().getDataReader().getParticle_amount()) - (double)a);
                    Vector v = new Vector(posX, posY, posZ);
                    this.displayParticles(Arrays.asList(location.add(v)));
                    location.subtract(v);
                }
            }
        }
    }

    @Override
    public void display(Player player) {
        this.calc(player);
    }
}

