/*
 * Decompiled with CFR 0.152.
 */
package tk.playerforcehd.shield.effect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import tk.playerforcehd.shield.Main;
import tk.playerforcehd.shield.effect.Effect;
import tk.playerforcehd.shield.effect.effects.CircleEffect;
import tk.playerforcehd.shield.effect.effects.ConeEffect;
import tk.playerforcehd.shield.effect.effects.CubeEffect;
import tk.playerforcehd.shield.effect.effects.HelixEffect;
import tk.playerforcehd.shield.effect.effects.NoFlexZoneEffect;
import tk.playerforcehd.shield.effect.effects.PointEffect;
import tk.playerforcehd.shield.effect.effects.SphereEffect;

public final class EffectManager {
    protected Effect current;
    private BukkitTask bukkitTask;
    private List<Effect> effects = Collections.synchronizedList(new ArrayList());

    public EffectManager() {
        this.loadDefaults();
    }

    private void loadDefaults() {
        this.effects.clear();
        this.effects.add(new PointEffect());
        this.effects.add(new CircleEffect());
        this.effects.add(new SphereEffect());
        this.effects.add(new ConeEffect());
        this.effects.add(new NoFlexZoneEffect());
        this.effects.add(new CubeEffect());
        this.effects.add(new HelixEffect());
    }

    public void startThread() {
        this.loadDefaults();
        for (Effect effect : this.effects) {
            if (!effect.getEffectType().equals((Object)Main.getInstance().getDataReader().getEffectType())) continue;
            this.current = effect;
            break;
        }
        this.bukkitTask = new BukkitRunnable(){

            public void run() {
                for (Player player : Main.getShieldUsers()) {
                    if (player.hasPermission("shield.use")) {
                        EffectManager.this.current.display(player);
                        continue;
                    }
                    Main.getShieldUsers().remove(player);
                    if (!Main.getInstance().isUseCrossServerEnabling()) continue;
                    Main.getInstance().getEnabledUsersTable().disable(player.getUniqueId());
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Main.getInstance(), 0L, (long)Main.getInstance().getDataReader().getParticleProcessSpeed());
    }

    public void stopThread() {
        this.bukkitTask.cancel();
    }

    public void restartThread() {
        this.stopThread();
        this.startThread();
    }
}

