/*
 * Decompiled with CFR 0.152.
 */
package tk.playerforcehd.shield.effect;

import java.util.ArrayList;
import java.util.Collection;
import jdk.nashorn.internal.objects.annotations.Getter;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import tk.playerforcehd.shield.DataReader;
import tk.playerforcehd.shield.Main;

public abstract class Effect {
    protected DataReader.EffectType effectType;

    public Effect(DataReader.EffectType effectType) {
        this.effectType = effectType;
    }

    public abstract void calc(Player var1);

    public abstract void display(Player var1);

    protected Location getBaseFoodLocation(Player player) {
        Location loc = Main.getInstance().getDataReader().getBaseParticleLocation() >= 0.0 ? player.getLocation().add(0.0, Main.getInstance().getDataReader().getBaseParticleLocation(), 0.0) : player.getLocation().subtract(0.0, Math.abs(Main.getInstance().getDataReader().getBaseParticleLocation()), 0.0);
        return loc;
    }

    protected Location getBaseEyeLocation(Player player) {
        Location loc_eye = Main.getInstance().getDataReader().getBaseParticleLocation() >= 0.0 ? player.getEyeLocation().add(0.0, Main.getInstance().getDataReader().getBaseParticleLocation(), 0.0) : player.getEyeLocation().subtract(0.0, Math.abs(Main.getInstance().getDataReader().getBaseParticleLocation()), 0.0);
        return loc_eye;
    }

    protected double getBaseRadius() {
        double radius = 0.0;
        radius = !Main.getInstance().getDataReader().isUseCustomRadius() ? (double)Main.getInstance().getDataReader().getRadius() : Main.getInstance().getDataReader().getCustomRadius();
        return radius;
    }

    protected synchronized void displayParticles(Collection<Location> locations) {
        ArrayList<Player> onlinePlayers = new ArrayList<Player>(Bukkit.getOnlinePlayers());
        for (Location loc : locations) {
            if (Main.getInstance().getDataReader().getEffectMode().equals((Object)DataReader.EffectMode.BUKKIT)) {
                loc.getWorld().playEffect(loc, Main.getInstance().getDataReader().getEffect(), 2);
                continue;
            }
            Main.getInstance().getDataReader().getParticleEffect().display(Main.getInstance().getDataReader().getParticle_offsetX(), Main.getInstance().getDataReader().getParticle_offsetY(), Main.getInstance().getDataReader().getParticle_offsetZ(), Main.getInstance().getDataReader().getParticle_speed(), Main.getInstance().getDataReader().getParticle_amount(), loc, onlinePlayers);
        }
    }

    @Getter
    public DataReader.EffectType getEffectType() {
        return this.effectType;
    }
}

