/*
 * Decompiled with CFR 0.152.
 */
package tk.playerforcehd.shield.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import tk.playerforcehd.shield.database.AbstractTable;
import tk.playerforcehd.shield.utils.Callback;
import tk.playerforcehd.shield.utils.mysql.MySQL;

public class EnabledUsersTable
extends AbstractTable {
    public EnabledUsersTable(MySQL mySQL) {
        super(mySQL);
    }

    @Override
    public void createTable() {
        this.getMySQL().executeUpdate(this.prepareStatement("CREATE TABLE IF NOT EXISTS shield_users(uuid CHAR(100) NOT NULL PRIMARY KEY)"));
    }

    public void isActive(UUID uuid, final Callback<Boolean> callback) {
        try {
            PreparedStatement ps = this.prepareStatement("SELECT * FROM shield_users WHERE uuid = ?");
            ps.setString(1, uuid.toString());
            this.getMySQL().executeQuery(ps, new Callback<ResultSet>(){

                @Override
                public void invoke(ResultSet object) {
                    try {
                        callback.invoke(object.next());
                    }
                    catch (SQLException e) {
                        callback.invoke(false);
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (SQLException e) {
            callback.invoke(false);
            e.printStackTrace();
        }
    }

    public void enable(final UUID uuid) {
        this.isActive(uuid, new Callback<Boolean>(){

            @Override
            public void invoke(Boolean object) {
                if (!object.booleanValue()) {
                    try {
                        PreparedStatement ps = EnabledUsersTable.this.prepareStatement("INSERT INTO shield_users(uuid) VALUES(?)");
                        ps.setString(1, uuid.toString());
                        EnabledUsersTable.this.getMySQL().executeUpdate(ps);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void disable(final UUID uuid) {
        this.isActive(uuid, new Callback<Boolean>(){

            @Override
            public void invoke(Boolean object) {
                if (object.booleanValue()) {
                    try {
                        PreparedStatement ps = EnabledUsersTable.this.prepareStatement("DELETE FROM shield_users WHERE uuid = ?");
                        ps.setString(1, uuid.toString());
                        EnabledUsersTable.this.getMySQL().executeUpdate(ps);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }
}

