/*
 * Decompiled with CFR 0.152.
 */
package tk.playerforcehd.shield.compatibility;

import jdk.nashorn.internal.objects.annotations.Getter;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import tk.playerforcehd.shield.compatibility.CompatibilityWorker;

public abstract class CompatibilityModule {
    private Plugin plugin;
    private boolean isEnabled = false;
    private String moduleName;
    private Class<? extends CompatibilityWorker> compatibilityWorkerClass;
    private CompatibilityWorker compatibilityWorker;

    public CompatibilityModule(String moduleName, CompatibilityWorker compatibilityWorker) {
        this.moduleName = moduleName;
        this.compatibilityWorkerClass = compatibilityWorker.getClass();
        this.compatibilityWorker = compatibilityWorker;
        this.loadPlugin();
    }

    private void loadPlugin() {
        this.plugin = Bukkit.getPluginManager().getPlugin(this.moduleName);
    }

    public boolean enable() {
        if (this.isEnabled) {
            return false;
        }
        this.isEnabled = true;
        this.onEnable();
        this.compatibilityWorker.startWorker();
        return true;
    }

    public boolean disable() {
        if (!this.isEnabled) {
            return false;
        }
        this.isEnabled = false;
        this.onDisable();
        this.compatibilityWorker.stopWorker();
        return true;
    }

    public abstract void onEnable();

    public abstract void onDisable();

    @Getter
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Getter
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Getter
    public String getModuleName() {
        return this.moduleName;
    }

    @Getter
    public Class<? extends CompatibilityWorker> getCompatibilityWorkerClass() {
        return this.compatibilityWorkerClass;
    }

    @Getter
    public CompatibilityWorker getCompatibilityWorker() {
        return this.compatibilityWorker;
    }
}

